var gulp         = require('gulp'),
	sass         = require('gulp-sass'),
	plumber      = require('gulp-plumber'),
	browserSync = require('browser-sync').create(),
	serveStatic = require("serve-static"),
	notify       = require('gulp-notify');

var config = {
	src           : './web/css/styles.scss',
	dest          : './web/css/'
};

// Error message
var onError = function (err) {
	notify.onError({
		title   : 'Gulp',
		subtitle: 'Failure!',
		message : 'Error: <%= error.message %>',
		sound   : 'Beep'
	})(err);

	this.emit('end');
};

// Compile CSS
gulp.task('styles', function () {
	var stream = gulp
		.src([config.src])
		.pipe(plumber({errorHandler: onError}))
		.pipe(sass().on('error', sass.logError));

	return stream
		.pipe(gulp.dest('./web/css/'));
});


var browserSyncConfig = {
	siteUrl: 'http://ottaviani.local/',
	files: ['web/css/*.css', '*.js'], //['**/*.php', paths.styles.dest + '*.css']
	whitelist: '', //['/wp-admin/admin-ajax.php'],
	blacklist: '', //['/wp-admin/**'],
	initialPath: ""
};

gulp.task('dev', function () {
	browserSync.init({
		proxy: browserSyncConfig.siteUrl,
		//Servo staticamente tutta la cartella ./dist/ a partire dal gulpfile.js
		middleware: serveStatic('dist'),
		//FUNZIONE, C'E' SOLO DA ESTENDERLO PER TUTTI I FILE CHE VANNO SERVITI STATICI (MODULI?, MAGENTO?)
		// rewriteRules: [
		// 	{
		// 		//Vado a matchare /skin/frontend/drop/default/dist/ e la riscrivo con nulla
		// 		//Quindi i file diventeranno serviti localmente a partire dalla cartella dist/
		// 		//Ad esempio //192.168.2.14:3000/styles/styles.min.css
		// 		match: new RegExp(basePaths.theme + basePaths.dest),
		// 		fn: function () {
		// 			return '';
		// 		}
		// 	},
		// 	{
		// 		//LO DEVO RIPETERE UNA SECONDA VOLTA PER FAR MATCHARE ANCHE IL JS - A L L U C I N A N T E (si vede che va file per file)
		// 		match: new RegExp(basePaths.theme + basePaths.dest),
		// 		fn: function () {
		// 			return '';
		// 		}
		// 	}
		// ],
		startPath: browserSyncConfig.initialPath,
		port: 3000,
		open: 'external',
		notify: false,
		files: browserSyncConfig.files,
		snippetOptions: {
			whitelist: browserSyncConfig.whitelist,
			blacklist: browserSyncConfig.blacklist
		}
	});

	gulp.watch('web/css/*.scss', ['styles']);
});
