<?php

namespace DropPaciottiCommon\Helper;

/**
 * Common function class
 */
class CommonFunction
{
    /**
     * @param  string   $size
     * @return string
     */
    public static function convertSize($size)
    {
        $size = trim($size);

        //from magento cloud db to informix
        if (empty($size)) {
            return 'N.';
        }

        //from informix to magento cloud
        if ('N.' == $size) {
            return '';
        }

        if (preg_match('/1\/2/', $size)) {
            $size = str_replace(' 1/2', '.5', $size);
        }

        return $size;
    }

    /**
     * @param  mixed    $m
     * @return string
     */
    public static function getMisura($m)
    {
        return self::convertSize($m);
    }

    /**
     * @param  string   $sku
     * @return string
     */
    public static function getModello($sku)
    {
        return substr($sku, 0, (strlen($sku) - CommonConst::NUMBER_CHAR_VARIANTE_END_OF_SKU));
    }

    /**
     * @param  string $sku
     * @return int
     */
    public static function getVariante($sku)
    {
        return (int) substr($sku, CommonConst::NEGATIVE_NUMBER_CHAR_VARIANTE_END_OF_SKU);
    }

    /**
     * @param  string   $sku
     * @return string
     */
    public static function getSkuWithoutVariante($sku)
    {
        return substr($sku, 0, CommonConst::NEGATIVE_NUMBER_CHAR_VARIANTE_END_OF_SKU);
    }
}
