<?php

namespace DropPaciottiCommon\Helper;

/**
 * Common const class
 */
class CommonConst
{
    /**
     * @var string
     */
    const LOCAL_PATH = 'PACIOTTI_STOCK_EXPORT_MAGENTO_CLOUD.json';

    /**
     * @var string
     */
    const SEMAPHORE = '.STOP_ERP_PACIOTTI_WRITING_STOCK_FILE';

    /**
     * @var string
     */
    const REMOTE_PATH = 'pub/media/stock';

    /**
     * @var string
     */
    const NUMBER_CHAR_VARIANTE_END_OF_SKU = 3;

    /**
     * @var string
     */
    const NEGATIVE_NUMBER_CHAR_VARIANTE_END_OF_SKU = -self::NUMBER_CHAR_VARIANTE_END_OF_SKU;

    /**
     * @var string
     */
    const TBL_STORICO = "storico_web";

    /**
     * @var string
     */
    const TBL_ECOMM = "ec_esiecomme";

    /**
     * @var string
     */
    const TBL_VEND = "vend_web";

    /**
     * @var string
     */
    const TBL_EC_IMPEGNIWEB = "ec_impegniweb";

    /**
     * @var string
     */
    const TBL_EC_STORICOWEB = "ec_storicoweb";

    /**
     * @var int
     */
    const ORDER_STATE_IMPEGNO = 0;

    /**
     * @var int
     */
    const ORDER_STATE_FATTURA = 1;

    /**
     * @var int
     */
    const ORDER_STATE_SPEDITO = 2;

    /**
     * @var int
     */
    const ORDER_STATE_CANCEL = 3;

    /**
     * @var int
     */
    const ORDER_STATE_NOTACREDITO = 4;
    /**
     * @var int
     */
    const ORDER_STATE_RESO = 5;

    /**
     * @var string
     */
    const WH_AMP = 'AMP';

    /**
     * @var string
     */
    const WH_JWL = 'JWL';

    /**
     * @var string
     */
    const WH_OTS = 'OTS';

    /**
     * @var string
     */
    const WH_MILANO = '00002';

    /**
     * @var string
     */
    const WH_ROMA = '00003';

    /**
     * @var string
     */
    const WH_CIVITANOVA = '00051';

    /**
     * @var string
     */
    const WH_US = '00005';

    /**
     * @var string
     */
    const WH_PACIOTTI = 'MIL';

    /**
     * @var string
     */
    const OP_DROP = 'DROP';

    /**
     * l'ordine è importante perché definisce la precedenza
     * @var array
     */
    public static $warehouses = array(
        self::WH_OTS,
        self::WH_MILANO,
        self::WH_ROMA,
        self::WH_CIVITANOVA,
        self::WH_US,
        self::WH_JWL,
        self::WH_AMP,
    );

    /**
     * @var array
     */
    public static $warehouses2 = array(
        self::WH_JWL        => 'jewels',
        self::WH_OTS        => 'ots',
        self::WH_MILANO     => 'milano',
        self::WH_ROMA       => 'roma',
        self::WH_CIVITANOVA => 'civitanova',
        self::WH_US         => 'us',
        self::WH_AMP        => 'montelpare',
    );

    /**
     * depositi non paciotti per i quali non bisogna scrivere sul db di frontiera
     * @var array
     */
    public static $warehouses_external = array(
        self::WH_JWL, self::WH_AMP,
    );
}
