<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Drop\Theme\Block;

class Cc extends \Magento\Framework\View\Element\Template
{
    /**
     * @var \Magento\CheckoutAgreements\Model\ResourceModel\Agreement\CollectionFactory
     */
    protected $_agreementCollectionFactory;
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var \Magento\Store\Model\Information
     */
    private $information;
    /**
     * @var \Magento\Store\Model\Store
     */
    private $store;

    /**
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Store\Model\Information $information
     * @param \Magento\Store\Model\Store $store
     * @param array $data
     * @codeCoverageIgnore
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Store\Model\Information $information,
        \Magento\Store\Model\StoreManagerInterface  $store,
        \Magento\Store\Model\Address\Renderer $renderer,
        array $data = []
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->information = $information;
        $this->store = $store;
        $this->renderer = $renderer;
        parent::__construct($context, $data);
    }

    /**
     * Get Magento Store Name Configuration
     * @return mixed
     */
    public function getStoreName() {
        return $this->scopeConfig->getValue('general/store_information/name', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
    }

    /**
     * Get Magento Shop Email
     * @return mixed
     */
    public function getShopEmail() {
        return $this->scopeConfig->getValue('trans_email/ident_custom1/email', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
    }

    /**
     * Get Magento Shop Address
     * @return mixed
     */
    public function getReturnAddress() {
        return $this->renderer->format($this->information->getStoreInformationObject($this->store->getStore()), 'text');
    }

    /**
     * Get Magento Home Url
     */
    public function getHomeUrl() {
        return $this->store->getStore()->getBaseUrl();
    }

    /**
     * Get Magento Account Url
     */
    public function getAccountUrl() {
        return $this->store->getStore()->getBaseUrl() . 'customer/account';
    }

    /**
     * TODO
     * @return bool
     */
    public function getIubendaIsActive() {
        return false;
    }

    /**
     * TODO
     * @return bool
     */
    public function getIubendaPrivacyPolicyCode() {
        return 0;
    }

}
