<?php

/**
 * Rewrite to exclude from product view empty select attributes
 * TODO: Check if is needed also for boolean attributes
 */

namespace Drop\Theme\Block\Product\View;

use Magento\Framework\Phrase;

/**
 * @api
 * @since 100.0.2
 */
class Attributes extends \Magento\Catalog\Block\Product\View\Attributes
{

    public function getAdditionalData(array $excludeAttr = [])
    {
        $data = [];
        $product = $this->getProduct();
        $attributes = $product->getAttributes();
        foreach ($attributes as $attribute) {
            if ($attribute->getIsVisibleOnFront() && !in_array($attribute->getAttributeCode(), $excludeAttr)) {
                $value = $attribute->getFrontend()->getValue($product);

                //Multiselect funziona correttamente. Se è settata viene mostrata e se non è settata non viene mostrata
                //Le select invece se non sono settate vengono mostrate con valore NO.
                //Da testare anche il tipo boolean che non ho avuto modo di testare
                if(($attribute->getFrontendInput() == 'select') && ($value == 'No')) {
                    //Exclude select value if empty
                    continue;
                }

                if ($value instanceof Phrase) {
                    $value = (string)$value;
                } elseif ($attribute->getFrontendInput() == 'price' && is_string($value)) {
                    $value = $this->priceCurrency->convertAndFormat($value);
                }

                if (is_string($value) && strlen($value)) {
                    $data[$attribute->getAttributeCode()] = [
                        'label' => __($attribute->getStoreLabel()),
                        'value' => $value,
                        'code' => $attribute->getAttributeCode(),
                    ];
                }
            }
        }
        return $data;
    }

}
