<?php
/**
 * @category    Magento 2
 * @copyright   Copyright (c) 2021 Drop (https://drop.it)
 * @author      Cavallaro <cavallaro@drop.it>
 */

declare(strict_types=1);


namespace Drop\Tax\Plugin;

use Drop\Tax\Helper\ConfigurationHelper;
use Magento\Tax\Api\Data\TaxRateInterface;
use Magento\Tax\Model\Calculation\Rate\Converter;

/**
 * Class AddCustomTaxRateField
 * @package Drop\Tax\Plugin
 */
class AddCustomTaxRateField
{

    /**
     * @param Converter $subject
     * @param $result
     * @param array $formData
     */
    public function afterPopulateTaxRateData(Converter $subject, $result, $formData)
    {
        $result->setFilterAmount($this->extractFormData($formData, ConfigurationHelper::FIELD_FILTER_AMOUNT))
            ->setAmountFrom($this->extractFormData($formData, ConfigurationHelper::FIELD_AMOUNT_FROM))
            ->setAmountTo($this->extractFormData($formData, ConfigurationHelper::FIELD_AMOUNT_TO));
        return $result;
    }

    /**
     * @param $formData
     * @param $fieldName
     * @return mixed|null
     */
    protected function extractFormData($formData, $fieldName)
    {
        if (isset($formData[$fieldName])) {
            return $formData[$fieldName];
        }
        return null;
    }

    /**
     * @param Converter $subject
     * @param $result
     * @param TaxRateInterface $taxRate
     * @param bool $returnNumericLogic
     */
    public function afterCreateArrayFromServiceObject(Converter $subject, $result, TaxRateInterface $taxRate, $returnNumericLogic = false)
    {
        $taxRateFormData = $result;
        $taxRateFormData[ConfigurationHelper::FIELD_FILTER_AMOUNT] = ($taxRate->getFilterAmount() ? true : false);
        $taxRateFormData[ConfigurationHelper::FIELD_AMOUNT_FROM] = $taxRate->getAmountFrom();
        $taxRateFormData[ConfigurationHelper::FIELD_AMOUNT_TO] = $taxRate->getAmountTo();

        return $taxRateFormData;
    }
}