<?php
/**
 * @category    Magento 2
 * @copyright   Copyright (c) 2021 Drop (https://drop.it)
 * @author      Cavallaro <cavallaro@drop.it>
 */

namespace Drop\Tax\Controller\Adminhtml\Rate;

use Drop\Tax\Helper\ConfigurationHelper;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Exception\NoSuchEntityException;

class Save extends \Magento\Tax\Controller\Adminhtml\Rate\Save
{
    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        $ratePost = $this->getRequest()->getPostValue();
        if ($ratePost) {
            $rateId = $this->getRequest()->getParam('tax_calculation_rate_id');
            if ($rateId) {
                try {
                    $this->_taxRateRepository->get($rateId);
                } catch (NoSuchEntityException $e) {
                    unset($ratePost['tax_calculation_rate_id']);
                }
            }

            try {
                $ratePost[ConfigurationHelper::FIELD_FILTER_AMOUNT] = $this->getRequest()->getParam(ConfigurationHelper::FIELD_FILTER_AMOUNT, 0);
                $taxData = $this->_taxRateConverter->populateTaxRateData($ratePost);
                $this->_taxRateRepository->save($taxData);

                $this->messageManager->addSuccess(__('You saved the tax rate.'));
                return $resultRedirect->setPath('*/*/');
            } catch (\Magento\Framework\Exception\LocalizedException $e) {
                $this->_objectManager->get(\Magento\Backend\Model\Session::class)->setFormData($ratePost);
                $this->messageManager->addError($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addError($e->getMessage());
            }
            return $resultRedirect->setUrl($this->_redirect->getRedirectUrl($this->getUrl('*')));
        }
        return $resultRedirect->setPath('tax/rate');
    }

}
