<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Drop\Tax\Setup\Patch\Data;

use Magento\Directory\Model\RegionFactory;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;
use Magento\Tax\Setup\TaxSetup;
use Magento\Tax\Setup\TaxSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;

/**
 * Class AddTacAttributeAndTaxClasses
 * @package Magento\Tax\Setup\Patch
 */
class AddAlternativeTaxAttribute implements DataPatchInterface, PatchVersionInterface
{
    /**
     * @param TaxSetupFactory $taxSetupFactory
     */
    private $taxSetupFactory;

    /**
     * @param RegionFactory $directoryRegionFactory
     */
    private $directoryRegionFactory;

    /**
     * @var \Magento\Framework\Setup\ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    /**
     * AddTacAttributeAndTaxClasses constructor.
     * @param TaxSetupFactory $taxSetupFactory
     * @param RegionFactory $directoryRegionFactory
     * @param ModuleDataSetupInterface $moduleDataSetup
     */
    public function __construct(
        TaxSetupFactory $taxSetupFactory,
        RegionFactory $directoryRegionFactory,
        ModuleDataSetupInterface $moduleDataSetup
    ) {
        $this->taxSetupFactory = $taxSetupFactory;
        $this->directoryRegionFactory = $directoryRegionFactory;
        $this->moduleDataSetup = $moduleDataSetup;
    }

    /**
     * {@inheritdoc}
     */
    public function apply()
    {
        /** @var TaxSetup $taxSetup */
        $taxSetup = $this->taxSetupFactory->create(['resourceName' => 'tax_setup', 'setup' => $this->moduleDataSetup]);

        /**
         * Add tax_class_id attribute to the 'eav_attribute' table
         */
        $taxSetup->addAttribute(
            \Magento\Catalog\Model\Product::ENTITY,
            'secondary_tax_class_id',
            [
                'group' => 'Product Details',
                'sort_order' => 45,
                'type' => 'int',
                'backend' => '',
                'frontend' => '',
                'label' => 'Secondary Tax Class',
                'input' => 'select',
                'class' => '',
                'source' => \Magento\Tax\Model\TaxClass\Source\Product::class,
                'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_WEBSITE,
                'visible' => true,
                'required' => false,
                'user_defined' => false,
                'default' => '2',
                'searchable' => true,
                'filterable' => false,
                'comparable' => false,
                'visible_on_front' => false,
                'visible_in_advanced_search' => false,
                'used_in_product_listing' => true,
                'unique' => false,
                'apply_to' => implode(',', $taxSetup->getTaxableItems()),
                'is_used_in_grid' => true,
                'is_visible_in_grid' => false,
                'is_filterable_in_grid' => true,
            ]
        );
    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public static function getVersion()
    {
        return '2.0.0';
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases()
    {
        return [];
    }
}
