<?php


namespace Drop\Tax\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Encryption\EncryptorInterface;
use Magento\Framework\Module\Dir;
use Magento\Store\Model\ScopeInterface;

class ConfigurationHelper extends AbstractHelper
{
    const FIELD_FILTER_AMOUNT = "filter_amount";
    const FIELD_AMOUNT_FROM = "amount_from";
    const FIELD_AMOUNT_TO = "amount_to";

    const XML_SECTION_MODULE = "drop_tax";

    const XML_GROUP_GENERAL = self::XML_SECTION_MODULE . "/general";
    const XML_PATH_GENERAL_ENABLED = self::XML_GROUP_GENERAL . "/enabled";
    const XML_PATH_GENERAL_LIMIT = self::XML_GROUP_GENERAL . "/limit";
    const XML_PATH_GENERAL_SECONDARY_TAX_CLASS = self::XML_GROUP_GENERAL . "/secondary_product_tax_class";
    const XML_PATH_GENERAL_SHIPPING_AMOUNT = self::XML_GROUP_GENERAL . "/shipping_amount";


    /**
     * ConfigurationHelper constructor.
     */
    public function __construct(
        Context $context
    )
    {
        parent::__construct($context);
    }

    /**
     * @param null $website
     * @return bool
     */
    public function isEnabled($website = null): bool
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_GENERAL_ENABLED, ScopeInterface::SCOPE_WEBSITE, $website);
    }

    /**
     * @param null $website
     * @return mixed
     */
    public function getLimit($website = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_GENERAL_LIMIT, ScopeInterface::SCOPE_WEBSITE, $website);
    }

    /**
     * @param null $website
     * @return mixed
     */
    public function getSecondaryProductTaxClassId($website = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_GENERAL_SECONDARY_TAX_CLASS, ScopeInterface::SCOPE_WEBSITE, $website);
    }

    /**
     * @param null $website
     * @return bool
     */
    public function addShippingAmount($website = null): bool
    {
        $this->scopeConfig->isSetFlag(self::XML_PATH_GENERAL_SHIPPING_AMOUNT, ScopeInterface::SCOPE_WEBSITE, $website);
    }
}