<?php

namespace Drop\SocialLogin\Model;

class Social extends \Mageplaza\SocialLogin\Model\Social
{
    /**
     * {@inheritdoc}
     */
    public function createCustomerSocial($data, $store)
    {
        /** @var CustomerInterface $customer */
        $customer = $this->customerDataFactory->create();
        $customer->setFirstname($data['firstname'])
            ->setLastname($data['lastname'])
            ->setEmail($data['email'])
            ->setStoreId($store->getId())
            ->setWebsiteId($store->getWebsiteId())
            ->setCreatedIn($store->getName())
            ->setCustomAttribute(
                \Drop\SocialLogin\Model\Support\Data::PRIVACY_POLICY_NAME_INPUT, 
                \Drop\SocialLogin\Model\Support\Data::PRIVACY_POLICY_VALUE_INPUT
            );

        try {
            // If customer exists existing hash will be used by Repository
            $customer = $this->customerRepository->save($customer);

            $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
            $mathRandom = $objectManager->get('Magento\Framework\Math\Random');
            $newPasswordToken = $mathRandom->getUniqueHash();
            $accountManagement = $objectManager->get('Magento\Customer\Api\AccountManagementInterface');
            $accountManagement->changeResetPasswordLinkToken($customer, $newPasswordToken);

            if ($this->apiHelper->canSendPassword($store)) {
                $this->getEmailNotification()->newAccount($customer, EmailNotificationInterface::NEW_ACCOUNT_EMAIL_REGISTERED_NO_PASSWORD);
            }

            $this->setAuthorCustomer($data['identifier'], $customer->getId(), $data['type']);
        } catch (AlreadyExistsException $e) {
            throw new InputMismatchException(
                __('A customer with the same email already exists in an associated website.')
            );
        } catch (Exception $e) {
            if ($customer->getId()) {
                $this->_registry->register('isSecureArea', true, true);
                $this->customerRepository->deleteById($customer->getId());
            }
            throw $e;
        }

        /** @var Customer $customer */
        $customer = $this->customerFactory->create()->load($customer->getId());

        return $customer;
    }
}