<?php

namespace Drop\SizeGuide\Model\Data;

use Drop\SizeGuide\Api\Data\AttributeValueInterface;
use Drop\SizeGuide\Helper\ConfigurationHelper;
use Drop\SizeGuide\Model\ResourceModel\AttributeValue as ResourceModel;
use Magento\Framework\Model\AbstractModel;

class AttributeValue extends AbstractModel  implements AttributeValueInterface
{
    protected $_eventPrefix = "drop_size_guide_attribute_value_model";

    protected $configuration;

    public function __construct(
        ConfigurationHelper $configurationHelper,
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []
    )
    {
        $this->configuration = $configurationHelper;

        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    public function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    public function getEntityId(): int
    {
        return $this->getData(self::ENTITY_ID);
    }

    public function getSizeGuideId(): ?int
    {
        return $this->getData(self::SIZE_GUIDE_ID) === null ? null : (int)$this->getData(self::SIZE_GUIDE_ID);
    }

    public function setSizeGuideId(?int $sizeGuideId): void
    {
        $this->setData(self::SIZE_GUIDE_ID, $sizeGuideId);
    }

    public function getAttributeId(): ?int
    {
        return $this->getData(self::ATTRIBUTE_ID) === null ? null : (int)$this->getData(self::ATTRIBUTE_ID);
    }

    public function setAttributeId(?int $attributeId): void
    {
        $this->setData(self::ATTRIBUTE_ID, $attributeId);
    }

    public function getValue(): ?string
    {
        return $this->getData(self::VALUE) === null ? null : (int)$this->getData(self::VALUE);
    }

    public function setValue(?string $value): void
    {
        $this->setData(self::VALUE, $value);
    }

    public function getAttribute()
    {
        foreach ($this->configuration->getGeneralAttributes() as $row) {
            if ($row->id != $this->getAttributeId()) {
                continue;
            }

            return $row->attribute;
        }

        return null;
    }
}
