<?php

namespace Drop\SizeGuide\Helper;


use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Encryption\EncryptorInterface;

class ConfigurationHelper extends AbstractHelper
{
    const XML_SECTION = "drop_size_guide";

    const XML_GROUP_GENERAL = self::XML_SECTION . "/general";
    const XML_PATH_ENABLED_MODULE = self::XML_GROUP_GENERAL . "/enabled";

    const XML_GROUP_COLUMNS = self::XML_SECTION . "/columns";
    const XML_PATH_SIZE_GUIDE_COLUMN = self::XML_GROUP_COLUMNS . "/general_size_guide";
    const XML_PATH_SKU_COLUMN = self::XML_GROUP_COLUMNS . "/general_sku";
    const XML_PATH_CATEGORY_COLUMN = self::XML_GROUP_COLUMNS . "/general_category";

    const XML_GROUP_RESOURCES = self::XML_SECTION . "/resources";
    const XML_PATH_RESOURCES_CATEGORIES = self::XML_GROUP_RESOURCES . "/categories";
    const XML_PATH_RESOURCES_SIZE_GUIDES_DEFAULT_LABEL = self::XML_GROUP_RESOURCES . "/size_guide_label";
    const XML_PATH_RESOURCES_SIZE_GUIDES = self::XML_GROUP_RESOURCES . "/size_guide";
    const XML_PATH_RESOURCES_ATTRIBUTES = self::XML_GROUP_RESOURCES . "/attributes";

    /* GENERAL */
    /**
     * @return bool
     */
    public function isEnabled(): bool
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_ENABLED_MODULE);
    }

    /**
     * @return string
     */
    public function getGeneralSizeGuideColumn(): string
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SIZE_GUIDE_COLUMN);
    }

    /**
     * @return string
     */
    public function getGeneralSkuColumn(): string
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SKU_COLUMN);
    }

    /**
     * @return string
     */
    public function getGeneralCategoryColumn(): string
    {
        return $this->scopeConfig->getValue(self::XML_PATH_CATEGORY_COLUMN);
    }

    /* RESOURCES */
    /**
     * @return object
     */
    public function getGeneralCategories(): object
    {
        return (object)json_decode($this->scopeConfig->getValue(self::XML_PATH_RESOURCES_CATEGORIES));
    }

    /**
     * @return string
     */
    public function getGeneralSizeGuideLabel(): string
    {
        return $this->scopeConfig->getValue(self::XML_PATH_RESOURCES_SIZE_GUIDES_DEFAULT_LABEL);
    }

    /**
     * @return object
     */
    public function getGeneralSizeGuide(): object
    {
        return (object)json_decode($this->scopeConfig->getValue(self::XML_PATH_RESOURCES_SIZE_GUIDES));
    }

    /**
     * @return object
     */
    public function getGeneralAttributes(): object
    {
        return (object)json_decode($this->scopeConfig->getValue(self::XML_PATH_RESOURCES_ATTRIBUTES));
    }

}
