<?php

namespace Drop\SizeGuide\Block\Adminhtml\Form\Field;


use Drop\SizeGuide\Block\Adminhtml\Form\Field\AttributeTypeColumn;
use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Framework\DataObject;
use Magento\Framework\Exception\LocalizedException;

class Attributes extends AbstractFieldArray
{
    private $renderer;

    /**
     * Prepare rendering the new field by adding all the needed columns
     */
    protected function _prepareToRender()
    {
        $this->addColumn('id', ['label' => __('Id (unique)'), 'class' => 'required-entry']);
        $this->addColumn('attribute', ['label' => __('Attribute'), 'class' => 'required-entry']);
        $this->addColumn('type',
            [
                'label'    => __('Type'),
                'renderer' => $this->getRenderer()
            ]);
        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add');
    }

    /**
     * Prepare existing row data object
     *
     * @param DataObject $row
     * @throws LocalizedException
     */
    protected function _prepareArrayRow(DataObject $row): void
    {
        $options = [];

        $type = $row->getType();
        if ($type !== null) {
            $options['option_' . $this->getRenderer()->calcOptionHash($type)] = 'selected="selected"';
        }

        $row->setData('option_extra_attrs', $options);
    }

    /**
     * @return \Magento\Framework\View\Element\BlockInterface
     * @throws LocalizedException
     */
    private function getRenderer()
    {
        if (!$this->renderer) {
            $this->renderer = $this->getLayout()->createBlock(
                AttributeTypeColumn::class,
                '',
                ['data' => ['is_render_to_js_template' => true]]
            );
        }

        return $this->renderer;
    }
}
