<?php

namespace Drop\SizeGuide\Model;

use Drop\SizeGuide\Api\Data\SizeGuideInterfaceFactory;
use Drop\SizeGuide\Model\ResourceModel\SizeGuide\CollectionFactory;
use Drop\SizeGuide\Model\ResourceModel\SizeGuide;
use Drop\SizeGuide\Api\Data\SizeGuideSearchResultInterfaceFactory;
use Drop\SizeGuide\Api\Data\SizeGuideInterface;
use Drop\SizeGuide\Api\SizeGuideRepositoryInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Api\SearchCriteria\CollectionProcessorInterface;

class SizeGuideRepository implements SizeGuideRepositoryInterface
{
    private $interfaceFactory;
    private $collectionFactory;
    private $resource;
    private $searchResult;
    private $collectionProcessor;

    /**
     * SizeGuideRepository constructor.
     * @param SizeGuideInterfaceFactory $sizeGuideInterfaceFactory
     * @param CollectionFactory $collectionFactory
     * @param SizeGuide $sizeGuide
     * @param SizeGuideSearchResultInterfaceFactory $sizeGuideSearchResultInterfaceFactory
     * @param CollectionProcessorInterface $collectionProcessor
     */
    public function __construct(
        SizeGuideInterfaceFactory $sizeGuideInterfaceFactory,
        CollectionFactory $collectionFactory,
        SizeGuide $sizeGuide,
        SizeGuideSearchResultInterfaceFactory $sizeGuideSearchResultInterfaceFactory,
        CollectionProcessorInterface $collectionProcessor
    )
    {
        $this->interfaceFactory = $sizeGuideInterfaceFactory;
        $this->collectionFactory = $collectionFactory;
        $this->resource = $sizeGuide;
        $this->searchResult = $sizeGuideSearchResultInterfaceFactory;
        $this->collectionProcessor = $collectionProcessor;
    }

    /**
     * @param $id
     * @return mixed
     */
    public function getById($id)
    {
        $factory = $this->interfaceFactory->create();
        $this->resource->load($factory, $id, SizeGuideInterface::ENTITY_ID);
        if (!$factory->getId()) {
            throw new NoSuchEntityException(__('Unable to find size guide with ID "%1"', $id));
        }

        return $factory;
    }

    /**
     * @param SizeGuideInterface $sizeGuide
     * @return SizeGuideInterface
     */
    public function save(SizeGuideInterface $sizeGuide)
    {
        $this->resource->save($sizeGuide);
        return $sizeGuide;
    }

    /**
     * @param SizeGuideInterface $sizeGuide
     */
    public function delete(SizeGuideInterface $sizeGuide)
    {
        $this->resource->delete($sizeGuide);
    }

    /**
     * @param SearchCriteriaInterface $searchCriteria
     * @return mixed
     */
    public function getList(SearchCriteriaInterface $searchCriteria)
    {
        $collection = $this->collectionFactory->create();
        $this->collectionProcessor->process($searchCriteria, $collection);
        $searchResults = $this->searchResult->create();

        $searchResults->setSearchCriteria($searchCriteria);
        $searchResults->setItems($collection->getItems());

        return $searchResults;
    }
}
