<?php

namespace Drop\SizeGuide\Model;

use Drop\SizeGuide\Api\Data\AttributeValueInterfaceFactory;
use Drop\SizeGuide\Model\ResourceModel\AttributeValue\CollectionFactory;
use Drop\SizeGuide\Model\ResourceModel\AttributeValue;
use Drop\SizeGuide\Api\Data\AttributeValueSearchResultInterfaceFactory;
use Drop\SizeGuide\Api\Data\AttributeValueInterface;
use Drop\SizeGuide\Api\AttributeValueRepositoryInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Api\SearchCriteria\CollectionProcessorInterface;

class AttributeValueRepository implements AttributeValueRepositoryInterface
{
    private $interfaceFactory;
    private $collectionFactory;
    private $resource;
    private $searchResult;
    private $collectionProcessor;

    /**
     * AttributeValueRepository constructor.
     * @param AttributeValueInterfaceFactory $attributeValueInterfaceFactory
     * @param CollectionFactory $collectionFactory
     * @param AttributeValue $attributeValue
     * @param AttributeValueSearchResultInterfaceFactory $attributeValueSearchResultInterfaceFactory
     * @param CollectionProcessorInterface $collectionProcessor
     */
    public function __construct(
        AttributeValueInterfaceFactory $attributeValueInterfaceFactory,
        CollectionFactory $collectionFactory,
        AttributeValue $attributeValue,
        AttributeValueSearchResultInterfaceFactory $attributeValueSearchResultInterfaceFactory,
        CollectionProcessorInterface $collectionProcessor
    )
    {
        $this->interfaceFactory = $attributeValueInterfaceFactory;
        $this->collectionFactory = $collectionFactory;
        $this->resource = $attributeValue;
        $this->searchResult = $attributeValueSearchResultInterfaceFactory;
        $this->collectionProcessor = $collectionProcessor;
    }

    /**
     * @param $id
     * @return mixed
     */
    public function getById($id)
    {
        $factory = $this->interfaceFactory->create();
        $this->resource->load($factory, $id, AttributeValue::ENTITY_ID);
        if (!$factory->getId()) {
            throw new NoSuchEntityException(__('Unable to find attribute value with ID "%1"', $id));
        }

        return $factory;
    }

    /**
     * @param AttributeValueInterface $attributeValue
     * @return AttributeValueInterface
     */
    public function save(AttributeValueInterface $attributeValue)
    {
        $this->resource->save($attributeValue);
        return $attributeValue;
    }

    /**
     * @param AttributeValueInterface $attributeValue
     */
    public function delete(AttributeValueInterface $attributeValue)
    {
        $this->resource->delete($attributeValue);
    }

    /**
     * @param SearchCriteriaInterface $searchCriteria
     * @return mixed
     */
    public function getList(SearchCriteriaInterface $searchCriteria)
    {
        $collection = $this->collectionFactory->create();
        $this->collectionProcessor->process($searchCriteria, $collection);
        $searchResults = $this->searchResult->create();

        $searchResults->setSearchCriteria($searchCriteria);
        $searchResults->setItems($collection->getItems());

        return $searchResults;
    }
}