<?php


namespace Drop\SizeGuide\Block\Adminhtml\Form\Field;


use Magento\Framework\View\Element\Context;
use Magento\Framework\View\Element\Html\Select;

class AttributeTypeColumn extends Select
{
    /**
     * AttributeTypeColumn constructor.
     * @param Context $context
     * @param array $data
     */
    public function __construct(
        Context $context,
        array $data = []
    )
    {
        parent::__construct($context, $data);
    }

    /**
     * Set "name" for <select> element
     *
     * @param string $value
     * @return $this
     */
    public function setInputName($value)
    {
        return $this->setName($value);
    }

    /**
     * Set "id" for <select> element
     *
     * @param $value
     * @return $this
     */
    public function setInputId($value)
    {
        return $this->setId($value);
    }

    /**
     * Render block HTML
     *
     * @return string
     */
    public function _toHtml(): string
    {
        if (!$this->getOptions()) {
            $this->setOptions($this->getSourceOptions());
        }
        return parent::_toHtml();
    }

    /**
     * @return array
     */
    private function getSourceOptions(): array
    {
        return [
            [
                "value" => "0",
                "label" => "",
            ],
            [
                "value" => "cm",
                "label" => "cm",
            ],
        ];
    }
}
