<?php

namespace Drop\SizeGuide\Model\Data;

use Drop\SizeGuide\Helper\ConfigurationHelper;
use Drop\SizeGuide\Model\ResourceModel\WebsiteConversion as ResourceModel;
use Drop\SizeGuide\Api\Data\WebsiteConversionInterface;
use Magento\Framework\Model\AbstractModel;
use Magento\Store\Api\WebsiteRepositoryInterface;

class WebsiteConversion extends AbstractModel  implements WebsiteConversionInterface
{
    protected $_eventPrefix = "drop_size_guide_website_collection_model";

    protected $configuration;
    protected $websiteRepository;

    public function __construct(
        ConfigurationHelper $configurationHelper,
        WebsiteRepositoryInterface $websiteRepository,
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []
    )
    {
        $this->configuration = $configurationHelper;
        $this->websiteRepository = $websiteRepository;

        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    public function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    public function getEntityId(): int
    {
        return $this->getData(self::ENTITY_ID);
    }

    public function getGeneralSizeId(): ?int
    {
        return $this->getData(self::GENERAL_SIZE_ID) === null ? null : (int)$this->getData(self::GENERAL_SIZE_ID);
    }

    public function setGeneralSizeId(?int $generalSizeId): void
    {
        $this->setData(self::GENERAL_SIZE_ID, $generalSizeId);
    }

    public function getWebsiteId(): ?int
    {
        return $this->getData(self::WEBSITE_ID) === null ? null : (int)$this->getData(self::WEBSITE_ID);
    }

    public function setWebsiteId(?int $websiteId): void
    {
        $this->setData(self::WEBSITE_ID, $websiteId);
    }

    public function getCategoryId(): ?int
    {
        return $this->getData(self::CATEGORY_ID) === null ? null : (int)$this->getData(self::CATEGORY_ID);
    }

    public function setCategoryId(?int $categoryId): void
    {
        $this->setData(self::CATEGORY_ID, $categoryId);
    }

    public function getConversion(): ?string
    {
        return $this->getData(self::CONVERSION) === null ? null : (string)$this->getData(self::CONVERSION);
    }

    public function setConversion(?string $conversion): void
    {
        $this->setData(self::CONVERSION, $conversion);
    }

    public function getGeneralSize()
    {
        foreach ($this->configuration->getGeneralSizeGuide() as $row) {
            if ($row->id != $this->getGeneralSizeId()) {
                continue;
            }

            return $row->size_guide;
        }

        return null;
    }

    public function getWebsite()
    {
        return $this->websiteRepository->getById($this->getWebsiteId());
    }
}
