<?php

namespace Drop\SizeGuide\Model;

use Drop\SizeGuide\Api\Data\WebsiteConversionInterfaceFactory;
use Drop\SizeGuide\Model\ResourceModel\WebsiteConversion\CollectionFactory;
use Drop\SizeGuide\Model\ResourceModel\WebsiteConversion;
use Drop\SizeGuide\Api\Data\WebsiteConversionSearchResultInterfaceFactory;
use Drop\SizeGuide\Api\Data\WebsiteConversionInterface;
use Drop\SizeGuide\Api\WebsiteConversionRepositoryInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Api\SearchCriteria\CollectionProcessorInterface;

class WebsiteConversionRepository implements WebsiteConversionRepositoryInterface
{
    private $interfaceFactory;
    private $collectionFactory;
    private $resource;
    private $searchResult;
    private $collectionProcessor;

    /**
     * WebsiteConversionRepository constructor.
     * @param WebsiteConversionInterfaceFactory $conversionInterfaceFactory
     * @param CollectionFactory $collectionFactory
     * @param WebsiteConversion $websiteConversion
     * @param WebsiteConversionSearchResultInterfaceFactory $websiteConversionSearchResultInterfaceFactory
     * @param CollectionProcessorInterface $collectionProcessor
     */
    public function __construct(
        WebsiteConversionInterfaceFactory $conversionInterfaceFactory,
        CollectionFactory $collectionFactory,
        WebsiteConversion $websiteConversion,
        WebsiteConversionSearchResultInterfaceFactory $websiteConversionSearchResultInterfaceFactory,
        CollectionProcessorInterface $collectionProcessor
    )
    {
        $this->interfaceFactory = $conversionInterfaceFactory;
        $this->collectionFactory = $collectionFactory;
        $this->resource = $websiteConversion;
        $this->searchResult = $websiteConversionSearchResultInterfaceFactory;
        $this->collectionProcessor = $collectionProcessor;
    }

    /**
     * @param $id
     * @return mixed
     */
    public function getById($id)
    {
        $factory = $this->interfaceFactory->create();
        $this->resource->load($factory, $id, WebsiteConversionInterface::ENTITY_ID);
        if (!$factory->getId()) {
            throw new NoSuchEntityException(__('Unable to find website conversion with ID "%1"', $id));
        }

        return $factory;
    }

    /**
     * @param WebsiteConversionInterface $websiteConversion
     * @return WebsiteConversionInterface
     */
    public function save(WebsiteConversionInterface $websiteConversion)
    {
        $this->resource->save($websiteConversion);
        return $websiteConversion;
    }

    /**
     * @param WebsiteConversionInterface $websiteConversion
     */
    public function delete(WebsiteConversionInterface $websiteConversion)
    {
        $this->resource->delete($websiteConversion);
    }

    /**
     * @param SearchCriteriaInterface $searchCriteria
     * @return mixed
     */
    public function getList(SearchCriteriaInterface $searchCriteria)
    {
        $collection = $this->collectionFactory->create();
        $this->collectionProcessor->process($searchCriteria, $collection);
        $searchResults = $this->searchResult->create();

        $searchResults->setSearchCriteria($searchCriteria);
        $searchResults->setItems($collection->getItems());

        return $searchResults;
    }
}