<?php

namespace Drop\SizeGuide\Model\Data;

use Drop\SizeGuide\Api\Data\SizeGuideInterface;
use Drop\SizeGuide\Helper\ConfigurationHelper;
use Drop\SizeGuide\Model\ResourceModel\SizeGuide as ResourceModel;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\Model\AbstractModel;

class SizeGuide extends AbstractModel implements SizeGuideInterface
{
    protected $_eventPrefix = "drop_size_guide_size_guide_model";

    protected $configuration;
    protected $productRepository;

    public function __construct(
        ConfigurationHelper $configurationHelper,
        ProductRepositoryInterface $productRepository,
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []
    )
    {
        $this->configuration = $configurationHelper;
        $this->productRepository = $productRepository;

        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    public function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    public function getEntityId(): int
    {
        return $this->getData(self::ENTITY_ID);
    }

    public function getProductId(): ?int
    {
        return $this->getData(self::PRODUCT_ID) === null ? null : (int)$this->getData(self::PRODUCT_ID);
    }

    public function setProductId(?int $productId): void
    {
        $this->setData(self::PRODUCT_ID, $productId);
    }

    public function getMasterId(): ?int
    {
        return $this->getData(self::MASTER_ID) === null ? null : (int)$this->getData(self::MASTER_ID);
    }

    public function setMasterId(?int $masterId): void
    {
        $this->setData(self::MASTER_ID, $masterId);
    }

    public function getCategoryId(): ?int
    {
        return $this->getData(self::CATEGORY_ID) === null ? null : (int)$this->getData(self::CATEGORY_ID);
    }

    public function setCategoryId(?int $categoryId): void
    {
        $this->setData(self::CATEGORY_ID, $categoryId);
    }

    public function getProduct()
    {
        try {
            $product = $this->productRepository->getById($this->getProductId());
        } catch (\Magento\Framework\Exception\NoSuchEntityException $noEntityException) {
            $product = null;
        }

        return $product;
    }

    public function getMasterSize()
    {
        foreach ($this->configuration->getGeneralSizeGuide() as $row) {
            if ($row->id != $this->getMasterId()) {
                continue;
            }

            return $row->size_guide;
        }

        return null;
    }

    public function getCategory()
    {
        foreach ($this->configuration->getGeneralCategories() as $row) {
            if ($row->id != $this->getCategoryId()) {
                continue;
            }

            return $row->category;
        }

        return null;
    }
}
