<?php

namespace Drop\ShipFromFile\Model;

use Magento\Framework\App\Config\ScopeConfigInterface;

class Config
{
    const XML_PATH_ENABLED = 'drop/general/enabled';
    const XML_PATH_SOURCE = 'drop/general/source_file';
    const XML_PATH_SOURCESTOCK = 'drop/general/source_file_stock';
    const XML_PATH_NOTIFICATION = 'drop/general/notification_references';


    private $config;

    public function __construct(ScopeConfigInterface $config)
    {
        $this->config = $config;
    }

    public function isEnabled()
    {
        return $this->config->getValue(self::XML_PATH_ENABLED);
    }

    public function sourcePath()
    {
        return $this->config->getValue(self::XML_PATH_SOURCE);
    }

    public function sourceStockPath()
    {
        return $this->config->getValue(self::XML_PATH_SOURCESTOCK);
    }

    public function notificationReferences()
    {
        return $this->config->getValue(self::XML_PATH_NOTIFICATION);
    }
}
