<?php

namespace Drop\ShipFromFile\Cron;

use Drop\ShipFromFile\Model\ItemFactory;
use Drop\ShipFromFile\Model\Config;
use Psr\Log\LoggerInterface;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\App\State;
use Magento\Contact\Model\ConfigInterface;
use Magento\Catalog\Model\ProductRepository;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory;
use Magento\CatalogInventory\Api\StockRegistryInterface;

class AddStock
{
    private $itemFactory;
    private $logger;
    private $config;
    private $state;
    private $_objectManager;
    private $productRepository;
    private $contactsConfig;
    private $productFactory;
    private $stockRegistry;
	
    public function __construct(
        ItemFactory $itemFactory,
        LoggerInterface $logger,
        Config $config,
        State $state,
        ObjectManagerInterface $objectManager,
        ProductRepository $productRepository,
        ConfigInterface $contactsConfig,
        CollectionFactory $productFactory,
        StockRegistryInterface $stockRegistry
        
    )
    {
        $this->itemFactory = $itemFactory;
        $this->logger = $logger;
        $this->config = $config;
        $this->state = $state;
        $this->_objectManager = $objectManager;
        $this->productRepository = $productRepository;
        $this->contactsConfig = $contactsConfig;
        $this->productFactory = $productFactory;
        $this->stockRegistry = $stockRegistry;
    }


    public function execute($dateInput)
    {

        if ($this->config->isEnabled()) {
            //test email
            //$this->sendEmail("subject", "body");

            if (is_dir($this->config->sourceStockPath())) {

                if ($dh = opendir($this->config->sourceStockPath())) {
                    while (($file = readdir($dh)) !== false) {

                        //name defaultfile not command
                        $nameFile = date("Y_m_d").'.json';

                        //check input
                        if(is_string($dateInput)){
                            $nameFile = date("Y_m_d", strtotime($dateInput)).'.json';
                        }

                        
                        if($nameFile == $file) {
                            //echo "filename: ".$file."<br />";
                            //echo $this->config->sourceStockPath() . $nameFile;
                            if (file_exists($this->config->sourceStockPath() . $nameFile)) {
	
                                $string = file_get_contents($this->config->sourceStockPath() . $nameFile);

                                if ($string === false) {
                                    $this->logger->debug('[ERROR]-> FILE NOT READ WITH NAME ' . $nameFile);
                                    $this->sendEmail('[Error] File', '[ERROR]-> FILE NOT READ WITH NAME ' . $nameFile);
                                }

                                $json_a = json_decode($string, true);
                               	//print_r($this->getProducts());die;
                                if ($json_a === null) {
                                    $this->logger->debug('[ERROR]-> FILE EMPTY WITH NAME ' . $nameFile);
                                    $this->sendEmail('[Error] File', '[ERROR]-> FILE EMPTY WITH NAME ' . $nameFile);
                                }
                                //$this->state->setAreaCode(\Magento\Framework\App\Area::AREA_CRONTAB);
                                $this->parseJsonFile($json_a, $nameFile, $this->getProducts());
				
                            } else {
                                print_r($this->config->sourceStockPath());die;
                                // file non esiste
                                $this->logger->debug('[ERROR]-> FILE NOT EXIST WITH NAME ' . $nameFile);
                                $this->sendEmail('[Error] File', '[ERROR]-> FILE NOT EXIST WITH NAME ' . $nameFile);
                            }
                        }
                    }
                    closedir($dh);
                }else{

                    //no open dir
                    $this->logger->debug('[ERROR]-> NO OPEN DIR. WITH NAME '.$this->config->sourceStockPath());
                    $this->sendEmail('[Error] File', '[ERROR]-> NO OPEN DIR. WITH NAME '.$this->config->sourceStockPath());
                }
            }else{

                //no directory
                $this->logger->debug('[ERROR]-> NO DIRECTORY WITH NAME '.$this->config->sourceStockPath());
                $this->sendEmail('[Error] File', '[ERROR]-> NO DIRECTORY WITH NAME '.$this->config->sourceStockPath());
            }
        }
    }

	public function parseJsonFile($jsonFromFile, $nameFile, $catalogo){
	    
		$this->setZeroCatalogo($catalogo['skus'], $nameFile);
		
		$itemDb = $this->itemFactory->create();
		$itemDb->setSource($nameFile);
		$skus = [];
		$barcodes = [];
		$elabSku = [];
		print_r('Elab from file');
		foreach ($jsonFromFile as $key => $item) {
		    
		    if (in_array($item['barcode'], $catalogo['barcodes'])) {
			    	print_r($item['barcode']);echo ' - ';
				    $product = $this->productFactory->create();
				    $product->addAttributeToSelect('*');
				    $product->addAttributeToFilter('barcode',['eq'=>$item['barcode']]);
				  
				    $product = $product->getFirstItem();
				    $sku = $product->getSku();
				    
				    // $product->setStockData(['qty' => $item['qty'], 'is_in_stock' => (bool)$item['qty']]);
				    // $product->setQuantityAndStockStatus(['qty' => $item['qty'], 'is_in_stock' => (bool)$item['qty']]);
				    // $product->save();
		        	$this->setQty($sku, $item['qty']);
		        	$elabSku[] = $sku;
				    $skus[] = $sku.'='.$item['qty'];
				    $barcodes[] = $item['barcode'].'='.$item['qty'];
			    }
		}
		print_r('End elab from file');
		$elabSku[] = 'gift-card';
		$itemDb->setOrderId(implode(' | ', $barcodes));
		$itemDb->setProductsSku(implode(' | ', $skus));
		$itemDb->setDateCreated(date("Y-m-d H:i:s"));
		$itemDb->setAction('Stock');
		$itemDb->setStatus('Elaborated');

		$itemDb->save();

	    }

    	public function setZeroCatalogo($allSkus, $nameFile){
		$itemDb = $this->itemFactory->create();
		$itemDb->setSource($nameFile);
		$counter = 'all '.count($allSkus);
		$itemDb->setOrderId($counter);
		$itemDb->setProductsSku(date("Y-m-d H:i:s"));
		$barcodes = [];
		print_r('Elab reset 0');
		foreach ($allSkus as $sku) {
	        $this->setQty($sku, 0);
		}
		print_r('End elab reset 0');

		$itemDb->setDateCreated(date("Y-m-d H:i:s"));
		$itemDb->setAction('Stock Zero');
		$itemDb->setStatus('Elaborated');

		$itemDb->save();
	}

	public function getProducts()
	{
	    
		$collection = $this->productFactory->create();
		$collection->addAttributeToSelect('*');
		//$collection->setPageSize(3);
		$barcodes = [];
		$allSkus = [];
		print_r('Inizio ciclo barcodes e skus dal catalogo');
		foreach($collection->getItems() as $item){
		    $allSkus[] = $item->getSku();
				$product = $this->productRepository->get( $item->getSku() );
				$barcodes[] = $product->getBarcode();
			}
			print_r('Fine ciclo barcodes e skus dal catalogo');    
		$catalogo = ['barcodes'=>$barcodes, 'skus'=>$allSkus];
		return $catalogo;
	}
	
	private function setQty($sku, $qty)
	{
	
	    $stockItem = $this->stockRegistry->getStockItemBySku( $sku );
	    $stockItem->setQty( $qty );
	    $stockItem->setIsInStock( (bool)$qty );
	    $this->stockRegistry->updateStockItemBySku( $sku, $stockItem );
		
	}

    private function sendEmail($subject, $body) {

        $emails = $this->config->notificationReferences();
        $email = explode(',', $emails);
        foreach($email as $to){
            $email = new \Zend_Mail();
            $email->setSubject($subject);
            $email->setBodyText($body);
            $email->setFrom($this->contactsConfig->emailRecipient(), $this->contactsConfig->emailSender());
            $email->addTo($to, $to);
            $email->send();
        }

    }
    
    
    
}

