<?php

namespace Drop\ShipFromFile\Cron;

use Drop\ShipFromFile\Model\ItemFactory;
use Drop\ShipFromFile\Model\Config;
use Psr\Log\LoggerInterface;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\App\State;
use Magento\Contact\Model\ConfigInterface;
use Magento\Catalog\Model\ProductRepository;
use Magento\Framework\Mail\Template\TransportBuilder;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Sales\Model\OrderRepository;

class AddItem
{
    private $itemFactory;
    private $logger;
    private $config;
    private $state;
    private $_objectManager;
    private $scopeConfig;
    private $productRepository;
    private $transportBuilder;
    private $storeManager;
    private $orderRepository;

    public function __construct(
        LoggerInterface $logger,
        ProductRepository $productRepository,
        ItemFactory $itemFactory,
        Config $config,
        State $state,
        ConfigInterface $contactsConfig,
        ObjectManagerInterface $objectManager,
        TransportBuilder $transportBuilder,
        StoreManagerInterface $storeManager,
        OrderRepository $orderRepository,
        ScopeConfigInterface $scopeConfig
    )
    {
        $this->contactsConfig = $contactsConfig;
        $this->state = $state;
        $this->itemFactory = $itemFactory;
        $this->productRepository = $productRepository;
        $this->config = $config;
        $this->logger = $logger;
        $this->scopeConfig = $scopeConfig;
        $this->_objectManager = $objectManager;
        $this->transportBuilder = $transportBuilder;
        $this->storeManager = $storeManager;
        $this->orderRepository = $orderRepository;
    }


    public function execute($dateInput)
    {

        if ($this->config->isEnabled()) {

            if (is_dir($this->config->sourcePath())) {

                if ($dh = opendir($this->config->sourcePath())) {
                    $existFile = false;
                    while (($file = readdir($dh)) !== false) {

                        //name defaultfile not command
                        $nameFile = date("Y_m_d").'.json';
		
                        //check input
                        if(is_string($dateInput)){
                            $nameFile = date("Y_m_d", strtotime($dateInput)).'.json';
                        }



                        if($nameFile == $file) {
                            $existFile = true;
                            //echo "filename: .".$file."<br />";
                            if (file_exists($this->config->sourcePath() . $nameFile)) {

                                $string = file_get_contents($this->config->sourcePath() . $nameFile);

                                if ($string === false) {
                                    $this->logger->debug('[ERROR]-> FILE NOT READ WITH NAME ' . $nameFile);
                                    $this->sendEmail('[Error] File', '[ERROR]-> FILE NOT READ WITH NAME ' . $nameFile);
                                }

                                $json_a = json_decode($string, true);
                                if ($json_a === null) {
                                    $this->logger->debug('[ERROR]-> FILE EMPTY WITH NAME ' . $nameFile);
                                    $this->sendEmail('[Error] File', '[ERROR]-> FILE EMPTY WITH NAME ' . $nameFile);
                                }
                                //$this->state->setAreaCode(\Magento\Framework\App\Area::AREA_CRONTAB);
                                $this->parseJsonFile($json_a, $nameFile);

                            } else {
                                // file non esiste
                                $this->logger->debug('[ERROR]-> FILE NOT EXIST WITH NAME ' . $nameFile);
                                $this->sendEmail('[Error] File', '[ERROR]-> FILE NOT EXIST WITH NAME ' . $nameFile);
                            }
                        }
                    }
                    if(!$existFile){
                        // file non esiste
                        $this->logger->debug('[ERROR]-> FILE NOT EXIST WITH NAME ' . $nameFile);
                        $this->sendEmail('[Error] File', '[ERROR]-> FILE NOT EXIST WITH NAME ' . $nameFile);
                    }

                    closedir($dh);
                }else{
                    //no open dir
                    $this->logger->debug('[ERROR]-> NO OPEN DIR. WITH NAME '.$this->config->sourcePath());
                    $this->sendEmail('[Error] File', '[ERROR]-> NO OPEN DIR. WITH NAME '.$this->config->sourcePath());
                }
            }else{
                //no directory
                $this->logger->debug('[ERROR]-> NO DIRECTORY WITH NAME '.$this->config->sourcePath());
                $this->sendEmail('[Error] File', '[ERROR]-> NO DIRECTORY WITH NAME '.$this->config->sourcePath());
            }
        }
    }

    public function parseJsonFile($jsonFromFile, $nameFile){
    
        foreach ($jsonFromFile as $key => $order) {
            $this->setToM2($order['numeroOrdine'], $order['items'], $order['tracks'], $nameFile);
        }
    }


    public function getProductsBundle()
    {
        
        $collection = $this->productFactory->create();
        $collection->addAttributeToSelect('*');
        //$collection->setPageSize(3);
        $barcodes = [];
            foreach($collection->getItems() as $item){
            $product = $this->productRepository->get( $item->getSku() );
            $barcodes[] = $product->getBarcode();
        }
        //print_r($barcodes);die;       
        return $barcodes;
    }


    public function setToM2($order_id, $items, $tracks, $nameFile)
    {
        $orderRef = $order_id;

        $itemDb =$this->itemFactory->create();
        $itemDb->setSource($nameFile);
        $itemDb->setOrderId($orderRef);


        $order_id = (int) $order_id;
        $order = $this->orderRepository->get($order_id);
    
        if (!$order->canShip()) {

            $error = 'You can\'t create an shipment for order increment_id '.$orderRef;
            $this->logger->debug($error);
            $this->sendEmail('[Error] Order id: '.$orderRef, $error);

            $itemDb->setDateCreated(date("Y-m-d H:i:s"));
            $itemDb->setAction('Shipping');
            $itemDb->setStatus($error);
            $itemDb->save();

           

        }


        $convertOrder = $this->_objectManager->create('Magento\Sales\Model\Convert\Order');

        $shipment = $convertOrder->toShipment($order);

        $skus = [];

        foreach ($order->getAllItems() AS $orderItem) {
/*
            $product = $this->productRepository->get( $orderItem->getSku() );

             //BUNDLE
            
            if($product->getTypeId() == 'bundle'){
                $childs = $product->getTypeInstance(true)->getChildrenIds($product->getId(), false);
                $inOrder = [];
                $qtyShippedChild = 0;
                foreach($childs as $array){
                    foreach($array as $id){
                        $productChild = $this->productRepository->getById( $id );
                        $toSearch = (string)$productChild->getBarcode();
                        $keyChild = array_search($toSearch, array_combine(array_keys($items), array_column($items, 'codiceArticolo')));

                        if($keyChild !== false) {
                            $qtyShippedChild = $items[$keyChild]['qtaAssegnate'];
                            $inOrder[] = ['codiceArticolo'=>$toSearch, 'qtaAssegnate'=>$items[$keyChild]['qtaAssegnate']];
                        }
                        //print_r($productChild->getBarcode());die;
                    }
                    
                }
                

                //$shipmentItem = $convertOrder->itemToShipmentItem($orderItem)->setQty($qtyShippedChild);
                $shipmentItem = $convertOrder->itemToShipmentItem($orderItem)->setQty($orderItem->getQtyToShip());

                $shipment->addItem($shipmentItem);
                $skus[] = $orderItem->getSku();
                //print_r($inOrder);die;
            }else{

            
                $toSearch = (string)$product->getBarcode();

                $key = array_search($toSearch, array_combine(array_keys($items), array_column($items, 'codiceArticolo')));

                if($key !== false) {

                   if (!$orderItem->getQtyToShip() || $orderItem->getIsVirtual()) {
                       continue;
                   }

                   //$qtyShipped = $items[$key]['qtaAssegnate'];
                   $qtyShipped = $orderItem->getQtyToShip();
                   $shipmentItem = $convertOrder->itemToShipmentItem($orderItem)->setQty($qtyShipped);

                   $shipment->addItem($shipmentItem);
                   $skus[] = $orderItem->getSku();
                }
            }
            */
           $shipmentItem = $convertOrder->itemToShipmentItem($orderItem)->setQty($orderItem->getQtyToShip());

           $shipment->addItem($shipmentItem);
           $skus[] = $orderItem->getSku();
       }

       if(count($skus)>0) {

           $skustring = implode(',', $skus);
           //print_r($skustring);die;
           $shipment->register();
           $tracks = $tracks[0];
           //print_r($tracks);die;
           $data = [
               'carrier_code' => $tracks['carrier_code'],
               'title' => $tracks['title'],
               'number' => $tracks['track_number']
           ];


           $shipment->getOrder()->setIsInProcess(true);


           try {

               $track = $this->_objectManager->create('Magento\Sales\Model\Order\Shipment\TrackFactory')->create()->addData($data);
               $shipment->addTrack($track)->save();
               $shipment->save();
               $shipment->getOrder()->save();
               $this->_objectManager->create('Magento\Shipping\Model\ShipmentNotifier')->notify($shipment);
               $shipment->save();


               try {

                   $itemDb->setProductsSku($skustring);
                   $itemDb->setTrack($tracks['track_number']);
                   $itemDb->setLink($tracks['link']);
                   $itemDb->setTitle($tracks['title']);
                   $itemDb->setCarrier($tracks['carrier_code']);
                   $itemDb->setDateCreated(date("Y-m-d H:i:s"));
                   $itemDb->setAction('Shipping');
                   $itemDb->setStatus('Elaborated');
                   $itemDb->save();


               } catch (\Exception $e) {
                   $this->logger->debug('Error -> ' . json_encode($e->getMessage()));
                   $this->sendEmail('[Error] Order id: '.$orderRef, json_encode($e->getMessage()));

                   $response = ['error' => $e->getMessage()];

                   $itemDb->setDateCreated(date("Y-m-d H:i:s"));
                   $itemDb->setAction('Shipping');
                   $itemDb->setStatus(json_encode($e->getMessage()));

                   $itemDb->save();
               }


           } catch (\Exception $e) {
               $this->logger->debug('Error -> ' . json_encode($e->getMessage()));
               $this->sendEmail('[Error] Order id: '.$orderRef, json_encode($e->getMessage()));
               $response = ['error' => $e->getMessage()];

               $itemDb->setDateCreated(date("Y-m-d H:i:s"));
               $itemDb->setAction('Shipping');
               $itemDb->setStatus(json_encode($e->getMessage()));
               $itemDb->save();
           }

           $response = [
               'success' => 'ok',
               'ordine_id' => $orderRef
           ];
           echo json_encode($response);

       }else {
            $error = 'No products find to match order items';

           $response = [
               'error' => $error,
               'ordine_id' => $orderRef
           ];
           $itemDb->setDateCreated(date("Y-m-d H:i:s"));
           $itemDb->setAction('Shipping');
           $itemDb->setStatus($error);
           $itemDb->save();

           $this->sendEmail('[Error] Order id: '.$orderRef, $error);

           echo json_encode($response);
       }
        return json_encode($response);
    }

    public function sendEmail($subject, $body) {
        //$this->state->setAreaCode(\Magento\Framework\App\Area::AREA_FRONTEND);

        $sender = [
            'name' => $this->scopeConfig->getValue("trans_email/ident_general/name", \Magento\Store\Model\ScopeInterface::SCOPE_STORE),
            'email' => $this->scopeConfig->getValue("trans_email/ident_general/email", \Magento\Store\Model\ScopeInterface::SCOPE_STORE),
        ];

        $templateVariable = [
            'subject' => $subject,
            'body' => $body
        ];



        try {
            $emails = $this->config->notificationReferences();
            $email = explode(',', $emails);
            foreach($email as $to){
                $transport = $this->transportBuilder
                    ->setTemplateIdentifier('error_ship_from_file')
                    ->setTemplateOptions(
                        [
                            'area' => \Magento\Framework\App\Area::AREA_FRONTEND,
                            'store' => $this->storeManager->getStore()->getStoreId(),
                        ]
                    )
                    ->setTemplateVars($templateVariable)
                    ->setFrom($sender)
                    ->addTo($to, $to)
                    ->getTransport();
                    $transport->sendMessage();
            }
        } catch (\Exception $e) {
            throw new \Exception($e->getMessage());
        }
    }
}


