<?php

namespace Drop\ShipFromFile\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Drop\ShipFromFile\Cron\AddStock;
use Magento\Framework\Console\Cli;

class CheckStock extends Command
{
    const INPUT_KEY_DATE = 'date';

    private $stock;

    public function __construct(AddStock $stock)
    {
        $this->stock = $stock;
        parent::__construct();
    }

    protected function configure()
    {

        $this->setName('drop:stockfromfile')
            ->addArgument(
                self::INPUT_KEY_DATE,
                InputArgument::OPTIONAL,
                'Date'
            );
        parent::configure();
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->stock->execute($input->getArgument(self::INPUT_KEY_DATE));
        return Cli::RETURN_SUCCESS;
    }

}
