<?php

namespace Drop\ShipFromFile\Cron;

use Drop\ShipFromFile\Model\ItemFactory;
use Drop\ShipFromFile\Model\Config;
use Psr\Log\LoggerInterface;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\App\State;
use Magento\Contact\Model\ConfigInterface;
use Magento\Catalog\Model\ProductRepository;
use Magento\InventoryApi\Api\SourceItemsSaveInterface;
use Magento\InventoryApi\Api\Data\SourceItemInterfaceFactory;


class AddStock
{
    private $itemFactory;
    private $logger;
    private $config;
    private $state;
    private $_objectManager;
    private $productRepository;
    private $sourceItemsSaveInterface;
    private $sourceItemFactory;

    public function __construct(
        LoggerInterface $logger,
        ProductRepository $productRepository,
        ItemFactory $itemFactory,
        Config $config,
        State $state,
        ConfigInterface $contactsConfig,
        ObjectManagerInterface $objectManager,
        SourceItemsSaveInterface $sourceItemsSaveInterface,
        SourceItemInterfaceFactory $sourceItemFactory
    )
    {
        $this->contactsConfig = $contactsConfig;
        $this->state = $state;
        $this->itemFactory = $itemFactory;
        $this->productRepository = $productRepository;
        $this->config = $config;
        $this->logger = $logger;
        $this->_objectManager = $objectManager;
        $this->sourceItemsSaveInterface = $sourceItemsSaveInterface;
        $this->sourceItemFactory = $sourceItemFactory;
    }


    public function execute($dateInput)
    {

        if ($this->config->isEnabled()) {
            //test email
            $this->sendEmail("subject", "body");

            if (is_dir($this->config->sourceStockPath())) {

                if ($dh = opendir($this->config->sourceStockPath())) {
                    while (($file = readdir($dh)) !== false) {

                        //name defaultfile not command
                        $nameFile = date("Y_m_d").'.json';

                        //check input
                        if($dateInput){
                            $nameFile = date("Y_m_d", strtotime($dateInput)).'.json';
                        }

                        //print_r($nameFile);die;


                        if($nameFile == $file) {
                            //echo "filename: .".$file."<br />";
                            if (file_exists($this->config->sourceStockPath() . $nameFile)) {

                                $string = file_get_contents($this->config->sourceStockPath() . $nameFile);

                                if ($string === false) {
                                    $this->logger->debug('[ERROR]-> FILE NOT READ WITH NAME ' . $nameFile);
                                    $this->sendEmail('[Error] File', '[ERROR]-> FILE NOT READ WITH NAME ' . $nameFile);
                                }

                                $json_a = json_decode($string, true);
                                if ($json_a === null) {
                                    $this->logger->debug('[ERROR]-> FILE EMPTY WITH NAME ' . $nameFile);
                                    $this->sendEmail('[Error] File', '[ERROR]-> FILE EMPTY WITH NAME ' . $nameFile);
                                }
                                $this->state->setAreaCode(\Magento\Framework\App\Area::AREA_CRONTAB);
                                $this->parseJsonFile($json_a, $nameFile);

                            } else {
                                // file non esiste
                                $this->logger->debug('[ERROR]-> FILE NOT EXIST WITH NAME ' . $nameFile);
                                $this->sendEmail('[Error] File', '[ERROR]-> FILE NOT EXIST WITH NAME ' . $nameFile);
                            }
                        }
                    }
                    closedir($dh);
                }else{
                    //no open dir
                    $this->logger->debug('[ERROR]-> NO OPEN DIR. WITH NAME '.$this->config->sourceStockPath());
                    $this->sendEmail('[Error] File', '[ERROR]-> NO OPEN DIR. WITH NAME '.$this->config->sourceStockPath());
                }
            }else{
                //no directory
                $this->logger->debug('[ERROR]-> NO DIRECTORY WITH NAME '.$this->config->sourceStockPath());
                $this->sendEmail('[Error] File', '[ERROR]-> NO DIRECTORY WITH NAME '.$this->config->sourceStockPath());
            }
        }
    }

    public function parseJsonFile($jsonFromFile, $nameFile){
        $itemDb = $this->itemFactory->create();
        $itemDb->setSource($nameFile);
        $skus = [];
        $barcodes = [];
        foreach ($jsonFromFile as $key => $item) {

            $product = $this->productRepository->get($item['barcode']);
            $sku = $product->getSku();
            $sourceItem = $this->sourceItemFactory->create();
            $sourceItem->setSourceCode('default');
            $sourceItem->setSku($sku);
            $sourceItem->setQuantity($item['qty']);
            //$sourceItem->setStatus((bool)$qta);
            $sourceItem->setStatus(1);


            $this->sourceItemsSaveInterface->execute([$sourceItem]);
            $skus[] = $sku.'='.$item['qty'];
            $barcodes[] = $item['barcode'].'='.$item['qty'];

        }

        $itemDb->setOrderId(implode(' | ', $barcodes));
        $itemDb->setProductsSku(implode(' | ', $skus));
        $itemDb->setDateCreated(date("Y-m-d H:i:s"));
        $itemDb->setAction('Stock');
        $itemDb->setStatus('Elaborated');

        $itemDb->save();
    }


    private function sendEmail($subject, $body) {

        $emails = $this->config->notificationReferences();
        $email = explode(',', $emails);
        foreach($email as $to){
            $email = new \Zend_Mail();
            $email->setSubject($subject);
            $email->setBodyText($body);
            $email->setFrom($this->contactsConfig->emailRecipient(), $this->contactsConfig->emailSender());
            $email->addTo($to, $to);
            $email->send();
        }

    }
}


