<?php
namespace Drop\ShipFromFile\Setup;

use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\ModuleContextInterface;

/**
 * @codeCoverageIgnore
 */
class InstallSchema implements InstallSchemaInterface
{
    /**
     * {@inheritdoc}
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();
        date_default_timezone_set("Europe/Rome");
        $table = $setup->getConnection()->newTable(
            $setup->getTable('drop_ship_from_file_item')
        )->addColumn(
            'id',
            Table::TYPE_INTEGER,
            null,
            ['identity' => true, 'nullable' => false, 'primary' => true],
            'ID'
        )->addColumn(
            'source',
            Table::TYPE_TEXT,
            255,
            ['nullable' => false],
            'Source File'
        )->addColumn(
            'order_id',
            Table::TYPE_TEXT,
            255,
            ['nullable' => false],
            'OrderId'
        )->addColumn(
            'products_sku',
            Table::TYPE_TEXT,
            255,
            ['nullable' => true],
            'Products Sku'
        )->addColumn(
            'track',
            Table::TYPE_TEXT,
            255,
            ['nullable' => true],
            'Track Number'
        )->addColumn(
            'link',
            Table::TYPE_TEXT,
            255,
            ['nullable' => true],
            'Link Track'
        )->addColumn(
            'title',
            Table::TYPE_TEXT,
            255,
            ['nullable' => true],
            'Title Carrier'
        )->addColumn(
            'carrier',
            Table::TYPE_TEXT,
            255,
            ['nullable' => true],
            'Carrier'
        )->addColumn(
            'date_created',
            Table::TYPE_DATETIME,
            50,
            ['nullable' => false],
            'DateCreated'
        )->addColumn(
            'status',
            Table::TYPE_TEXT,
            255,
            ['nullable' => true],
            'Status'
        )->addIndex(
            $setup->getIdxName('drop_ship_from_file_item', ['source']),
            ['source']
        )->setComment(
            'Drop Ship From File Items'
        );



        $setup->getConnection()->createTable($table);
    }
}
