<?php

namespace Drop\ShipFromFile\Setup;

use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

class InstallData implements InstallDataInterface
{
    /**
     * {@inheritdoc}
     */
    public function install(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();

        $setup->getConnection()->insert(
            $setup->getTable('drop_ship_from_file_item'),
            [
                'source'=>'YYYY_MM_DD.json',
                'order_id' => '100001',
                'products_sku'=> 'BLK-MED-G123-GUC,GRE-MED-G124-MTD,RED-MED-G124-SWA',
                'track' => '1Y-9876543210',
                'link' => 'http://esempio.com?track=1Y-9876543210',
                'title' => 'United Parcel Service',
                'carrier' => 'ups',
                'date_created' => date("Y-m-d H:i:s"),
                'status' => 'Elaborated'
            ]
        );


        $setup->endSetup();
    }
}