<?php

namespace Drop\ShipFromFile\Cron;

use Drop\ShipFromFile\Model\ItemFactory;
use Drop\ShipFromFile\Model\Config;
use Psr\Log\LoggerInterface;


class AddItem
{
    private $itemFactory;
    private $logger;
    private $config;

    public function __construct(LoggerInterface $logger, ItemFactory $itemFactory, Config $config)
    {
        $this->itemFactory = $itemFactory;
        $this->config = $config;
        $this->logger = $logger;
    }

    public function execute()
    {
        if ($this->config->isEnabled()) {

            //$this->logger->debug('start Cron');
            //$this->logger->debug(__DIR__);

            //$this->logger->debug($this->config->sourcePath());
            /*$this->itemFactory->create()
                ->setSource('Test')
                ->setOrderId('100001')
                ->setProductsSku('BLK-MED-G123-GUC,GRE-MED-G124-MTD,RED-MED-G124-SWA')
                ->setTrack('1Y-9876543210')
                ->setLink('http://esempio.com?track=1Y-9876543210')
                ->setTitle('United Parcel Service')
                ->setCarrier('ups')
                ->setDateCreated(date("Y-m-d H:i:s"))
                ->setStatus('Elaborated')
                ->save();*/

            if (is_dir($this->config->sourcePath())) {

                if ($dh = opendir($this->config->sourcePath())) {
                    while (($file = readdir($dh)) !== false) {
                        echo "filename: .".$file."<br />";
                        //check exist file
                        $nameFile = date("Y_m_d").'.json';
                        if(file_exists($this->config->sourcePath().$nameFile)){
                            $string = file_get_contents($this->config->sourcePath().$nameFile);
                            if ($string === false) {
                                $this->logger->debug('[ERROR]-> FILE NOT READ WITH NAME '.$nameFile);
                            }
                            $json_a = json_decode($string, true);
                            if ($json_a === null) {
                                $this->logger->debug('[ERROR]-> FILE EMPTY WITH NAME '.$nameFile);
                            }

                            $this->parseJsonFile($json_a);

                        }else{
                            // file non esiste
                            $this->logger->debug('[ERROR]-> FILE NOT EXIST WITH NAME '.$nameFile);
                        }
                    }
                    closedir($dh);
                }else{
                    //no open dir
                    $this->logger->debug('[ERROR]-> NO OPEN DIR. WITH NAME '.$this->config->sourcePath());
                }
            }else{
                //no directory
                $this->logger->debug('[ERROR]-> NO DIRECTORY WITH NAME '.$this->config->sourcePath());
            }
        }
    }

    public function parseJsonFile($jsonFromFile){
        foreach ($jsonFromFile as $key => $order) {
            //echo $order['numeroOrdine'];
            $this->logger->debug('[SOLVE]-> numeroOrdine '.$order['numeroOrdine']);
        }
    }
}