<?php

namespace Drop\ShipFromFile\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Drop\ShipFromFile\Cron\AddItem;
use Drop\ShipFromFile\Cron\AddStock;
use Magento\Framework\Console\Cli;

class CheckFile extends Command
{
    const INPUT_KEY_DATE = 'date';

    private $item;

    public function __construct(AddItem $item)
    {
        $this->item = $item;
        parent::__construct();
    }

    protected function configure()
    {
        $this->setName('drop:shipfromfile')
            ->addArgument(
                self::INPUT_KEY_DATE,
                InputArgument::OPTIONAL,
                'Date'
            );
        parent::configure();
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->item->execute($input->getArgument(self::INPUT_KEY_DATE));
        return Cli::RETURN_SUCCESS;
    }
}
