<?php

namespace Drop\Sendinblue\Model;

/**
 * Class Sendinblue
 *
 * @property $this configuration
 * @package \\${NAMESPACE}
 */
class Connection extends \Magento\Framework\Model\AbstractModel
{

    /**
     * @var \Drop\Sendinblue\Helper\Data
     */
    private $helper;

    /**
     * @var \SendinBlue\Client\Configuration
     */
    private $configurationInstance;

    /**
     * @var \GuzzleHttp\Client
     */
    private $guzzle;

    /**
     * @var \Magento\Framework\App\Filesystem\DirectoryList
     */
    private $directoryList;

    /**
     * Sendinblue constructor.
     * @param \SendinBlue\Client\Configuration $configurationInstance
     * @param \GuzzleHttp\Client $guzzle
     * @param \Drop\Sendinblue\Helper\Data $helper
     */
    public function __construct(
        \SendinBlue\Client\Configuration $configurationInstance,
        \GuzzleHttp\Client $guzzle,
        \Drop\Sendinblue\Helper\Data $helper,
        \Magento\Framework\App\Filesystem\DirectoryList $directoryList
    )
    {
        $this->helper = $helper;
        $this->guzzle = $guzzle;
        $this->configurationInstance = $configurationInstance;
        $this->directoryList = $directoryList;
    }

    /**
     * Connect to Sendinblue V3 API
     * @param $factoryApi
     * @return mixed
     */
    public function connect($factoryApi) {
        $configuration = $this->configurationInstance
                        ->getDefaultConfiguration()
                        ->setApiKey('api-key', $this->helper->getApiKey());

        if($this->helper->getDebug()) {
            $configuration->setDebug(true)
                ->setDebugFile($this->directoryList->getPath('log') . '/sendinblue.log');
        }

        return $factoryApi->create(['client' => $this->guzzle, 'config' => $configuration]);
    }


}
