<?php

namespace Drop\Sendinblue\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class UnsubscribeAllContacts extends Command
{
    /**
     * @var \Drop\Sendinblue\Logger\Logger
     */
    protected $logger;
    /**
     * @var \Drop\Sendinblue\Model\Api\ContactsApi
     */
    private $contactsApi;
    /**
     * @var \Drop\Sendinblue\Model\SubscriberFactory
     */
    private $sendinblueSubscriberFactory;
    /**
     * @var \Drop\Sendinblue\Model\SubscriberFactory
     */
    private $state;

    /**
     * UnsubscribeAllContacts constructor.
     * @param \Drop\Sendinblue\Model\SubscriberFactory $sendinblueSubscriberFactory
     * @param \Drop\Sendinblue\Model\Api\ContactsApi $contactsApi
     * @param \Drop\Sendinblue\Logger\Logger $logger
     * @param \Magento\Framework\App\State $state
     */
    public function __construct(
        \Drop\Sendinblue\Model\SubscriberFactory $sendinblueSubscriberFactory,
        \Drop\Sendinblue\Model\Api\ContactsApi $contactsApi,
        \Drop\Sendinblue\Logger\Logger $logger,
        \Magento\Framework\App\State $state
    ) {
        $this->sendinblueSubscriberFactory = $sendinblueSubscriberFactory;
        $this->contactsApi = $contactsApi;
        $this->logger = $logger;
        $this->state = $state;

        parent::__construct();
    }

    protected function configure()
    {
        $this->setName('drop:sendinblue:unsubscribe-contacts')
            ->setDescription('Sendinblue delete contacts.');
    }

    /**
     * Delete last changed unsubscribers from Sendinblue
     * @return $this
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function execute(InputInterface $input, OutputInterface $output) {
        try {
            // this tosses an error if the areacode is not set.
            $this->state->getAreaCode();
        } catch (\Exception $e) {
            $this->state->setAreaCode('adminhtml');
        }

        $unsubscribers = $this->sendinblueSubscriberFactory->create()->getAllUnsubscriber();
        if(!$unsubscribers->count()) {
            $output->writeln('Unsubscribers not found in Magento.');
            return $this;
        }

        $output->writeln('Found: ' . $unsubscribers->count() . ' contacts. Unsubscribing...');
        foreach($unsubscribers as $unsubscriber) {
            $this->contactsApi->setConnection()->deleteContact($unsubscriber->getSubscriberEmail());
        }

        $output->writeln('Unsubscribed contacts from Sendinblue.');
        return $this;
    }

}
