<?php
namespace Drop\Sendinblue\Cron;

class UnsubscribeContacts {

    /**
     * @var \Drop\Sendinblue\Logger\Logger
     */
    protected $logger;
    /**
     * @var \Drop\Sendinblue\Model\Api\ContactsApi
     */
    private $contactsApi;
    /**
     * @var \Drop\Sendinblue\Model\Subscriber
     */
    private $sendinblueSubscriber;

    /**
     * Export constructor.
     * @param \Drop\Sendinblue\Model\Subscriber $sendinblueSubscriber
     * @param \Drop\Sendinblue\Model\Api\ContactsApi $contactsApi
     * @param \Drop\Sendinblue\Logger\Logger $logger
     */
    public function __construct(
        \Drop\Sendinblue\Model\Subscriber $sendinblueSubscriber,
        \Drop\Sendinblue\Model\Api\ContactsApi $contactsApi,
        \Drop\Sendinblue\Logger\Logger $logger
    ) {
        $this->sendinblueSubscriber = $sendinblueSubscriber;
        $this->contactsApi = $contactsApi;
        $this->logger = $logger;
    }

    /**
     * Send last changed unsubscribers to Sendinblue
     * @return $this
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function execute() {
        $unsubscribers = $this->sendinblueSubscriber->getLastChangedUnsubscriber();
        if(!$unsubscribers->count()) {
            return $this;
        }

        foreach($unsubscribers as $unsubscriber) {
            $this->contactsApi->setConnection()->deleteContact($unsubscriber->getSubscriberEmail());
        }

        return $this;
    }
}
