<?php

namespace Drop\Sendinblue\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Input\InputArgument;

class UnsubscribeTargetContact extends Command
{
    /**
     * @var \Drop\Sendinblue\Logger\Logger
     */
    protected $logger;
    /**
     * @var \Drop\Sendinblue\Model\Api\ContactsApi
     */
    private $contactsApi;
    /**
     * @var \Drop\Sendinblue\Model\Subscriber
     */
    private $sendinblueSubscriber;
    /**
     * @var \Magento\Framework\App\State
     */
    private $state;


    const ARGUMENT_CONTACT_EMAILS = 'emails';

    /**
     * ExportContacts constructor.
     * @param \Drop\Sendinblue\Model\Subscriber $sendinblueSubscriber
     * @param \Drop\Sendinblue\Model\Api\ContactsApi $contactsApi
     * @param \Drop\Sendinblue\Logger\Logger $logger
     * @param \Magento\Framework\App\State $state
     */
    public function __construct(
        \Drop\Sendinblue\Model\Subscriber $sendinblueSubscriber,
        \Drop\Sendinblue\Model\Api\ContactsApi $contactsApi,
        \Drop\Sendinblue\Logger\Logger $logger,
        \Magento\Framework\App\State $state
    ) {
        $this->sendinblueSubscriber = $sendinblueSubscriber;
        $this->contactsApi = $contactsApi;
        $this->logger = $logger;
        $this->state = $state;
        parent::__construct();
    }

    protected function configure()
    {
        //SAMPLE: m drop:sendinblue:export-target-contact c.pieroni@drop.it
        $this->setName('drop:sendinblue:unsubscribe-target-contact')
            ->setDescription('Sendinblue unsubscribe target contacts.');

        $this->addArgument(
            self::ARGUMENT_CONTACT_EMAILS,
            InputArgument::REQUIRED,
            'Contact emails (comma serated).'
        );
    }

    /**
     * Send last changed subscribers to Sendinblue
     * @return $this
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function execute(InputInterface $input, OutputInterface $output) {
        try {
            // this tosses an error if the areacode is not set.
            $this->state->getAreaCode();
        } catch (\Exception $e) {
            $this->state->setAreaCode('adminhtml');
        }

        $unsubscribersEmails = explode(',', $input->getArgument(self::ARGUMENT_CONTACT_EMAILS));
        $unsubscribers = $this->sendinblueSubscriber->getTargetUnsubscribers($unsubscribersEmails);
        if(!$unsubscribers->count()) {
            $output->writeln('Unsubscribers not found in Magento.');
            return $this;
        }

        $output->writeln('Found: ' . $unsubscribers->count() . ' contacts. Unsubscribing...');
        foreach($unsubscribers as $unsubscriber) {
            $this->contactsApi->setConnection()->deleteContact($unsubscriber->getSubscriberEmail());
        }

        $output->writeln('Unsubscribed contacts from Sendinblue.');
        return $this;
    }

}
