<?php

namespace Drop\Sendinblue\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class ExportAllContacts extends Command
{
    /**
     * @var \Drop\Sendinblue\Logger\Logger
     */
    protected $logger;
    /**
     * @var \Drop\Sendinblue\Model\Api\ContactsApi
     */
    private $contactsApi;
    /**
     * @var \Drop\Sendinblue\Model\SubscriberFactory
     */
    private $sendinblueSubscriberFactory;
    /**
     * @var \Magento\Framework\App\State
     */
    private $state;

    /**
     * ExportContacts constructor.
     * @param \Drop\Sendinblue\Model\SubscriberFactory $sendinblueSubscriberFactory
     * @param \Drop\Sendinblue\Model\Api\ContactsApi $contactsApi
     * @param \Drop\Sendinblue\Logger\Logger $logger
     * @param \Magento\Framework\App\State $state
     */
    public function __construct(
        \Drop\Sendinblue\Model\SubscriberFactory $sendinblueSubscriberFactory,
        \Drop\Sendinblue\Model\Api\ContactsApi $contactsApi,
        \Drop\Sendinblue\Logger\Logger $logger,
        \Magento\Framework\App\State $state
    ) {
        $this->sendinblueSubscriberFactory = $sendinblueSubscriberFactory;
        $this->contactsApi = $contactsApi;
        $this->logger = $logger;
        $this->state = $state;
        parent::__construct();
    }

    protected function configure()
    {
        $this->setName('drop:sendinblue:export-all-contacts')
            ->setDescription('Sendinblue export contacts.');
    }

    /**
     * Send last changed subscribers to Sendinblue
     * @return $this
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function execute(InputInterface $input, OutputInterface $output) {
        try {
            // this tosses an error if the areacode is not set.
            $this->state->getAreaCode();
        } catch (\Exception $e) {
            $this->state->setAreaCode('adminhtml');
        }

        $subscribersData = $this->sendinblueSubscriberFactory->create()->setAllSubscriber()->mapMagentoSubscriberFieldsToSendinblue();
        if(count($subscribersData) == 0) {
            $output->writeln('Contacts not found in Magento.');
            return $this;
        }

        $output->writeln('Found: ' . count($subscribersData) . ' contacts. Importing...');
        $this->contactsApi->setConnection()->importContacts($subscribersData);
        $output->writeln('Contacts exported to Sendinblue.');
        return $this;
    }

}
