<?php

namespace Drop\Sendinblue\Model\ResourceModel\Attributes;

/**
 * Class Collection
 *
 * @package \Drop\Sendinblue\Model\ResourceModel
 */
class Collection extends \Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection {

    public function _construct()
    {
        $this->_init(
            "Drop\Sendinblue\Model\Attributes",
            "Drop\Sendinblue\Model\ResourceModel\Attributes"
        );
    }

    /**
     * @param $attributeType
     * @return $this
     */
    public function addTypeFilter($attributeType){
        $this->addFieldToSelect('type')
            ->addFieldToFilter('type', $attributeType);
        return $this;
    }

    /**
     * @param $attributeCode
     * @return $this
     */
    public function getAttributeType($attributeCode){
        $this->addFieldToSelect('type')
            ->addFieldToFilter('attribute_code', $attributeCode);
        return $this;
    }

    /**
     * @param $frontendLabel
     * @return $this
     */
    public function addFrontendLabelFilter($frontendLabel){
        $this->addFieldToSelect('frontend_label')
            ->addFieldToFilter('frontend_label', $frontendLabel);
        return $this;
    }

    /**
     * @param $attributeCode
     * @return $this
     */
    public function getAttributeFrontendLabel($attributeCode){
        $this->addFieldToSelect('frontend_label')
            ->addFieldToFilter('attribute_code', $attributeCode);
        return $this;
    }

    /**
     * @param $attributeCode
     * @return $this
     */
    public function getAttributeCode($attributeCode){
        $this->addFieldToSelect('attribute_code')
            ->addFieldToFilter('attribute_code', $attributeCode);
        return $this;
    }

    /**
     * Delete all attributes
     * @return int
     */
    public function deleteAll() {
        $deletedAttributes = 0;
        foreach($this as $attribute) {
            try {
                $attribute->delete();
                $deletedAttributes++;
            } catch (\Exception $e) {
                $this->logger->error("Cannot delete attribute {$attribute->getName()}: " . $e->getMessage());
            }
        }
        return $deletedAttributes;
    }
}
