<?php

namespace Drop\Sendinblue\Model\Api;

/**
 * Class Account
 *
 * @package \Drop\Sendinblue\Model
 */
class AccountApi
{
    protected $connection;
    /**
     * @var \Drop\Sendinblue\Logger\Logger
     */
    private $logger;
    /**
     * @var \Drop\Sendinblue\Model\Connection
     */
    private $connectionInstance;
    /**
     * @var \SendinBlue\Client\Api\AccountApiFactory
     */
    private $accountApiFactory;

    /**
     * AccountApi constructor.
     * @param \Drop\Sendinblue\Model\Connection $connectionInstance
     * @param \SendinBlue\Client\Api\AccountApiFactory $accountApiFactory
     * @param \Drop\Sendinblue\Logger\Logger $logger
     */
    public function __construct(
        \Drop\Sendinblue\Model\Connection $connectionInstance,
        \SendinBlue\Client\Api\AccountApiFactory $accountApiFactory,
        \Drop\Sendinblue\Logger\Logger $logger
    )
    {
        $this->logger = $logger;
        $this->connectionInstance = $connectionInstance;
        $this->accountApiFactory = $accountApiFactory;
    }

    public function setConnection() {
        if(!$this->connection) {
            $this->connection = $this->connectionInstance->connect($this->accountApiFactory);
        }
        return $this;
    }

    public function getConnection() {
        if(!$this->connection) {
            $this->setConnection();
        }
        return $this->connection;
    }

    /**
     * https://github.com/sendinblue/APIv3-php-library/blob/master/docs/Api/AccountApi.md#getaccount
     * @return mixed
     */
    public function getAccount() {
        try {
            return $this->connection->getAccount();
        } catch (\Exception $e) {
            $this->logger->error('Exception when calling AccountApi->getAccount: ' . $e->getMessage());
        }
    }



}
