<?php
namespace Drop\Sendinblue\Cron;

class ExportContacts {

    /**
     * @var \Drop\Sendinblue\Logger\Logger
     */
    protected $logger;
    /**
     * @var \Drop\Sendinblue\Model\Api\ContactsApi
     */
    private $contactsApi;
    /**
     * @var \Drop\Sendinblue\Model\Subscriber
     */
    private $sendinblueSubscriber;

    /**
     * Export constructor.
     * @param \Drop\Sendinblue\Model\Subscriber $sendinblueSubscriber
     * @param \Drop\Sendinblue\Model\Api\ContactsApi $contactsApi
     * @param \Drop\Sendinblue\Logger\Logger $logger
     */
    public function __construct(
        \Drop\Sendinblue\Model\Subscriber $sendinblueSubscriber,
        \Drop\Sendinblue\Model\Api\ContactsApi $contactsApi,
        \Drop\Sendinblue\Logger\Logger $logger
    ) {
        $this->sendinblueSubscriber = $sendinblueSubscriber;
        $this->contactsApi = $contactsApi;
        $this->logger = $logger;
    }

    /**
     * Send last changed subscribers to Sendinblue
     * @return $this
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function execute() {
        $subscribersData = $this->sendinblueSubscriber->setLastChangedSubscriber()->mapMagentoSubscriberFieldsToSendinblue();
        if(!$subscribersData) {
            return $this;
        }

        $this->contactsApi->setConnection()->importContacts($subscribersData);

        return $this;
    }
}
