<?php

namespace Drop\Rma\Model\Allrma\Pdf;

class Rma extends \Webkul\Rmasystem\Model\Allrma\Pdf\Rma
{

    /**
     * Totals models excluded from printing in totals
     * @var array
     */
    protected $toExcludeFromPdfDocumentTotals = [
        'MSP\CashOnDelivery\Model\Sales\Pdf\Amount',
        'MSP\CashOnDelivery\Model\Sales\Pdf\Tax',
        'Magento\Tax\Model\Sales\Pdf\Shipping'
    ];

    /**
     * Override RMA totals dispplay with Drop needs
     * @return array|\Magento\Sales\Model\Order\Pdf\Total\DefaultTotal[]
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    protected function _getTotalsList()
    {
        $totals = $this->_pdfConfig->getTotals();
        usort($totals, [$this, '_sortTotalsList']);
        $totalModels = [];

        foreach ($totals as $totalInfo) {
            $class = empty($totalInfo['model']) ? null : $totalInfo['model'];
            if(in_array($class, $this->toExcludeFromPdfDocumentTotals)) {
                continue;
            }
            $totalModel = $this->_pdfTotalFactory->create($class);
            $totalModel->setData($totalInfo);
            $totalModels[] = $totalModel;
        }

        return $totalModels;
    }

}
