<?php
/**
 * Pdf
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Rma\Helper;

use Drop\Rma\Model\Allrma;

use Magento\Framework\App\Helper\Context;
use Magento\Sales\Model\Order\Address\Renderer;
use Magento\Payment\Helper\Data as PaymentHelper;
use Magento\Sales\Model\Order\Email\Container\InvoiceIdentity;
use Eadesigndev\Pdfgenerator\Model\Template\Processor;
use \Magento\Framework\Filesystem;
use Magento\Framework\App\Filesystem\DirectoryList;
use Eadesigndev\Pdfgenerator\Model\Source\TemplatePaperForm;
use Eadesigndev\Pdfgenerator\Model\Source\TemplatePaperOrientation;
use \Magento\Sales\Model\OrderFactory;
use \Eadesigndev\Pdfgenerator\Helper\Data;
use Magento\Sales\Model\Order\Invoice;
use Magento\Sales\Model\Order;
use Magento\Sales\Model\Order\ItemRepository;
use Webkul\Rmasystem\Api\ReasonRepositoryInterface;
use Eadesigndev\Pdfgenerator\Model\MpdfFactory;

class Pdf extends \Eadesigndev\Pdfgenerator\Helper\Pdf
{

    /**
     * @var TemplatePaperForm
     */
    private $templatePaperForm;
    /**
     * @var TemplatePaperOrientation
     */
    private $templatePaperOrientation;
    /**
     * @var DirectoryList
     */
    private $directoryList;
    /**
     * @var Filesystem
     */
    private $filesystem;
    /**
     * @var Data
     */
    private $helper;
    /**
     * @var OrderFactory
     */
    private $orderFactory;

    /**
     * @var rma;
     */
    public $rma;

    /**
     * @var ItemRepository
     */
    protected $orderItemRepository;

    /**
     * @var ReasonRepositoryInterface
     */
    protected $reasonRepository;

    private $mpdfFactory;

    /**
     * Pdf constructor.
     * @param Context $context
     * @param Renderer $addressRenderer
     * @param PaymentHelper $paymentHelper
     * @param InvoiceIdentity $identityContainer
     * @param Processor $templateFactory
     * @param Filesystem $filesystem
     * @param DirectoryList $directoryList
     * @param TemplatePaperForm $templatePaperForm
     * @param TemplatePaperOrientation $templatePaperOrientation
     * @param Data $helper
     * @param OrderFactory $orderFactory
     */
    public function __construct(
        Context $context,
        Renderer $addressRenderer,
        PaymentHelper $paymentHelper,
        InvoiceIdentity $identityContainer,
        Processor $templateFactory,
        Filesystem $filesystem,
        DirectoryList $directoryList,
        TemplatePaperForm $templatePaperForm,
        TemplatePaperOrientation $templatePaperOrientation,
        Data $helper,
        OrderFactory $orderFactory,
        ItemRepository $orderItemRepository,
        ReasonRepositoryInterface $reasonRepository,
        MpdfFactory $mpdfFactory
    ) {
        $this->processor                = $templateFactory;
        $this->paymentHelper            = $paymentHelper;
        $this->identityContainer        = $identityContainer;
        $this->addressRenderer          = $addressRenderer;
        $this->filesystem            = $filesystem;
        $this->directoryList            = $directoryList;
        $this->templatePaperForm        = $templatePaperForm;
        $this->templatePaperOrientation = $templatePaperOrientation;
        $this->helper = $helper;
        $this->orderFactory = $orderFactory;
        $this->orderItemRepository = $orderItemRepository;
        $this->reasonRepository = $reasonRepository;
        $this->mpdfFactory              = $mpdfFactory;
        parent::__construct($context, $addressRenderer, $paymentHelper, $identityContainer, $templateFactory, $directoryList, $templatePaperForm, $templatePaperOrientation, $mpdfFactory);
    }

    /**
     * @param Allrma $rma
     * @return $this
     */
    public function setRma(Allrma $rma)
    {
        $this->rma = $rma;
        foreach($rma->getOrder()->getInvoiceCollection() as $invoice) {
            $this->setInvoice($invoice);
            break;
        }
        return $this;
    }

    public function _transport()
    {
        $order = $this->order;

        $invoice = '';
        $invoice_comment = '';
        if($this->invoice instanceof Invoice) {
            $invoice = $this->invoice;
            $invoice_comment = $invoice->getCustomerNoteNotify() ? $invoice->getCustomerNote() : '';
        }

        $creditmemo = '';
        $creditmemo_comment = '';
        if($this->creditmemo instanceof Creditmemo) {
            $creditmemo = $this->creditmemo;
            $creditmemo_comment = $creditmemo->getCustomerNoteNotify() ? $creditmemo->getCustomerNote() : '';
        }

        $rma = '';
        $rmaItemHtml = '';
        $rmaTotal = '';
        if($this->rma instanceof Allrma) {
            $rma = $this->rma;
            foreach($rma->getItemsCollection() as $rmaItem) {
                $mageItem = $this->orderItemRepository->get($rmaItem->getItemId());
                $rmaItemHtml .= "
                    <tr>
                        <td>
                            <p class='product-name'>".$mageItem->getName()."</p>
                            <p class='sku'>SKU: ".$mageItem->getSku()."</p>
                        </td>
                        <td>" . $rmaItem->getQty() . "</td>
                        <td>" . $order->formatPrice($mageItem->getPriceInclTax()) . "</td>
                        <td><span>" . __($this->reasonRepository->getById($rmaItem->getReasonId())->getReason()) ."</span></td>
                    </tr>";
            }
            $rmaTotal = $order->formatPrice($rma->getGrandTotal());
        }

        $transport = [
            'order' => $order,
            'invoice' => $invoice,
            'creditmemo' => $creditmemo,
            'rma' => $rma,
            'rma_items' => $rmaItemHtml,
            'rma_total' => $rmaTotal,
            'invoice_comment' => $invoice_comment,
            'creditmemo_comment' => $creditmemo_comment,
            'billing' => $order->getBillingAddress(),
            'payment_html' => $this->getPaymentHtml($order),
            'paymentInfo' => $order->getPayment()->getMethodInstance()->getTitle(),
            'store' => $order->getStore(),
            'formattedShippingAddress' => $this->getFormattedShippingAddress($order),
            'formattedBillingAddress' => $this->getFormattedBillingAddress($order),
            'logo_path' => $this->filesystem->getDirectoryRead(DirectoryList::MEDIA)->getAbsolutePath() . 'email/logo/' . $this->helper->hasConfig('design/email/logo')
        ];

        $processor = $this->processor;
        $processor->setVariables($transport);
        $processor->setTemplate($this->template);
        $parts = $processor->processTemplate();

        return $parts;
    }

}
