<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Drop\Rma\Controller\Adminhtml\Order\Rma;

use Eadesigndev\Pdfgenerator\Controller\Adminhtml\Order\Abstractpdf;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Registry;
use Magento\Email\Model\Template\Config;
use Magento\Framework\Controller\Result\JsonFactory;
use \Drop\Rma\Helper\Pdf;
use Magento\Framework\Stdlib\DateTime\DateTime;
use Magento\Framework\App\Response\Http\FileFactory;
use Eadesigndev\Pdfgenerator\Model\PdfgeneratorRepository;
use Magento\Backend\Model\View\Result\ForwardFactory;
use Magento\Framework\App\Filesystem\DirectoryList;

class Printpdf extends Abstractpdf
{
    /**
     * Authorization level of a basic admin session
     *
     * @see _isAllowed()
     */
//    const ADMIN_RESOURCE = 'Magento_Sales::sales_invoice';

    /**
     * @var DateTime
     */
    private $dateTime;

    /**
     * @var FileFactory
     */

    private $fileFactory;
    /**
     * @var ForwardFactory
     */

    private $resultForwardFactory;

    /**
     * @var Pdf
     */
    private $helper;

    /**
     * @var PdfgeneratorRepository
     */
    private $pdfGeneratorRepository;

    /**
     * Printpdf constructor.
     * @param Context $context
     * @param Registry $coreRegistry
     * @param Config $emailConfig
     * @param JsonFactory $resultJsonFactory
     * @param Pdf $helper
     * @param DateTime $dateTime
     * @param FileFactory $fileFactory
     * @param ForwardFactory $resultForwardFactory
     * @param PdfgeneratorRepository $pdfGeneratorRepository
     */
    public function __construct(
        Context $context,
        Registry $coreRegistry,
        Config $emailConfig,
        JsonFactory $resultJsonFactory,
        Pdf $helper,
        DateTime $dateTime,
        FileFactory $fileFactory,
        ForwardFactory $resultForwardFactory,
        PdfgeneratorRepository $pdfGeneratorRepository
    )
    {
        $this->fileFactory = $fileFactory;
        $this->helper = $helper;
        $this->dateTime = $dateTime;
        $this->resultForwardFactory = $resultForwardFactory;
        $this->pdfGeneratorRepository = $pdfGeneratorRepository;
        parent::__construct($context, $coreRegistry, $emailConfig, $resultJsonFactory);
    }

    /**
     * @return \Magento\Framework\View\Result\Page
     */
    public function execute()
    {
        $templateId = $this->getRequest()->getParam('template_id');
        if (!$templateId) {
            return $this->returnNoRoute();
        }

        $templateModel = $this->pdfGeneratorRepository->getById($templateId);
        if (!$templateModel) {
            return $this->returnNoRoute();
        }

        /** @var \Magento\Framework\View\Result\Page $resultPage */
        $id = $this->getRequest()->getParam('rma_id');
        if (!$id) {
            $resultForward = $this->resultForwardFactory->create();
            $resultForward->forward('noroute');
            return $resultForward;
        }

        $rma = $this->_objectManager->get('Webkul\Rmasystem\Model\Allrma')->load($id);
        if (!$rma) {
            $resultForward = $this->resultForwardFactory->create();
            $resultForward->forward('noroute');
            return $resultForward;
        }

        $templateModel = $this->pdfGeneratorRepository->getById($templateId);
        $this->helper->setRma($rma);
        $this->helper->setTemplate($templateModel);

        $pdfFileData = $this->helper->template2Pdf();

        $date = $this->dateTime->date('Y-m-d_H-i-s');
        $fileName = $pdfFileData['filename'] . $date . '.pdf';

        return $this->fileFactory->create(
            $fileName,
            $pdfFileData['filestream'],
            DirectoryList::VAR_DIR,
            'application/pdf'
        );
    }
}
