<?php
/**
 * EaDesgin
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE_AFL.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@eadesign.ro so we can send you a copy immediately.
 *
 * @category    eadesigndev_pdfgenerator
 * @copyright   Copyright (c) 2008-2016 EaDesign by Eco Active S.R.L.
 * @license     http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 */

namespace Drop\Rma\Block\Plugin;

use Eadesigndev\Pdfgenerator\Helper\Data;
use Magento\Framework\App\Request\Http;
use Magento\Framework\UrlInterface;
use Webkul\Rmasystem\Model\AllrmaFactory;

class Printrma
{
    /**
     * @var UrlInterface
     */
    private $urlInterface;

    /**
     * @var Http
     */
    protected $request;

    /**
     * @var Data
     */
    private $dataHelper;

    /**
     * @var AllrmaFactory
     */
    private $rmaFactory;

    /**
     * Printrma constructor.
     * @param Http $request
     * @param UrlInterface $urlInterface
     * @param Data $dataHelper
     */
    public function __construct(
        \Magento\Framework\App\Request\Http $request,
        UrlInterface $urlInterface,
        Data $dataHelper,
        AllrmaFactory $rmaFactory
    ) {
        $this->request = $request;
        $this->urlInterface = $urlInterface;
        $this->dataHelper = $dataHelper;
        $this->rmaFactory = $rmaFactory;
    }

    protected function getRma($rmaId) {
        return $this->rmaFactory->create()->load($rmaId);
    }

    public function afterGetDownloadPdfUrl($subject, $result)
    {
        if (!$this->dataHelper->isEnable()) {
            return $result;
        }

        $rmaId = $this->request->getParam('id');
        if (empty($rmaId)) {
            return $result;
        }

        $rma = $this->getRma($rmaId);
        if (empty($rma) || empty($rma->getId())) {
            return $result;
        }

        $rmaTemplate = $this->dataHelper->getTemplateStatus($rma);
        if (empty($rmaTemplate) || empty($rmaTemplate->getId())) {
            return $result;
        }

        return $this->urlInterface->getUrl('droprma/order_rma/printpdf',
            [
                'template_id' => $rmaTemplate->getId(),
                'order_id' => $rma->getOrder()->getId(),
                'rma_id' => $rmaId
            ]
        );
    }
}
