<?php
/**
 * Author: Simone Monterubbiano <s.monterubbiano@drop.it>
 * Date: 04/10/2018
 * File name: PlaceAfter.php
 * Project: doppelganger
 */

namespace Drop\Rma\Observer;


class CompletedAt implements \Magento\Framework\Event\ObserverInterface
{

    protected $date;

    public function __construct(
        \Magento\Framework\Stdlib\DateTime\DateTime $date
    ) {
        $this->date = $date;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $shipment = $observer->getEvent()->getShipment();
        if(!isset($shipment) || ($shipment->getId() != NULL) ||
            ($shipment->getCompletedAt() != NULL)
        ) {
            return $this;
        }

        /** @var \Magento\Sales\Model\Order $order */
        $order = $shipment->getOrder();
        if(!isset($order) || !($order->getId() != NULL) ||
            ($order->getStatus() != 'shipped')
        ) {
            return $this;
        }

        $offset = ($this->date->getGmtOffset() / (60*60));
        $shipment->setCompletedAt(date("Y-m-d H:i:s",strtotime("+{$offset} hours", strtotime($this->date->gmtDate()))));
        return $this;
    }
}
