<?php

namespace Drop\Rma\Helper;

use Drop\Rma\Model\Allrma;
use Eadesigndev\Pdfgenerator\Model\ResourceModel\Pdfgenerator\CollectionFactory as templateCollectionFactory;
use Eadesigndev\Pdfgenerator\Model\Source\TemplateActive;
use Eadesigndev\Pdfgenerator\Model\Source\AbstractSource;

/**
 * Data
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

class Data
{

    /**
     * @var Collection
     */
    public $templateCollection;

    public function __construct(
        templateCollectionFactory $_templateCollection
    ) {
        $this->templateCollection = $_templateCollection;
    }

    public function aroundGetTemplateStatus($subject, \Closure $proceed, $result)
    {
        if($result instanceof Allrma) {
            $template_type = \Drop\Rma\Model\Source\TemplateType::TYPE_RMA;
        } else {
            return $proceed($result);
        }

        $stores = $result->getOrder()->getStoreId();
        $collection =  $this->templateCollection->create()
            ->addStoreFilter($stores)
            ->addFieldToFilter('is_active', TemplateActive::STATUS_ENABLED)
            ->addFieldToFilter('template_default', AbstractSource::IS_DEFAULT)
            ->addFieldToFilter('template_type', $template_type);
        return $collection->getLastItem();
    }

}
