<?php
/**
 * Pdf
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\RmaMirasvit\Helper;

use Mirasvit\Rma\Model\Rma;

use Magento\Framework\App\Helper\Context;
use Magento\Sales\Model\Order\Address\Renderer;
use Magento\Payment\Helper\Data as PaymentHelper;
use Magento\Sales\Model\Order\Email\Container\InvoiceIdentity;
use Eadesigndev\Pdfgenerator\Model\Template\Processor;
use \Magento\Framework\Filesystem;
use Magento\Framework\App\Filesystem\DirectoryList;
use Eadesigndev\Pdfgenerator\Model\Source\TemplatePaperForm;
use Eadesigndev\Pdfgenerator\Model\Source\TemplatePaperOrientation;
use \Magento\Sales\Model\OrderFactory;
use \Eadesigndev\Pdfgenerator\Helper\Data;
use Magento\Sales\Model\Order\Invoice;
use Magento\Sales\Model\Order;
use Magento\Sales\Model\Order\ItemRepository;
use Mirasvit\Rma\Api\Repository\ReasonRepositoryInterface;
use Mirasvit\Rma\Api\Service\Rma\RmaManagementInterface;
use Mirasvit\Rma\Service\Rma\RmaManagement;
use Mirasvit\Rma\Service\Rma\RmaOrder;
use Mirasvit\Rma\Api\Service\Item\ItemManagementInterface;
use Mirasvit\Rma\Api\Service\Rma\RmaManagement\SearchInterface;
use Drop\FatturazioneElettronica\Model\Utilities as FAEUtilities;
use Eadesigndev\Pdfgenerator\Model\MpdfFactory;

class Pdf extends \Eadesigndev\Pdfgenerator\Helper\Pdf
{

    /**
     * @var TemplatePaperForm
     */
    private $templatePaperForm;
    /**
     * @var TemplatePaperOrientation
     */
    private $templatePaperOrientation;
    /**
     * @var DirectoryList
     */
    private $directoryList;
    /**
     * @var Filesystem
     */
    private $filesystem;
    /**
     * @var Data
     */
    private $helper;
    /**
     * @var OrderFactory
     */
    private $orderFactory;

    /**
     * @var rma;
     */
    public $rma;

    /**
     * @var ItemRepository
     */
    protected $orderItemRepository;

    /**
     * @var ReasonRepositoryInterface
     */
    protected $reasonRepository;
    /**
     * @var Mirasvit\Rma\Api\Service\Rma\RmaManagementInterface
     */
    private $rmaManagement;
    /**
     * @var Mirasvit\Rma\Service\Rma\RmaOrder
     */
    private $rmaOrder;
    /**
     * @var \Mirasvit\Rma\Api\Service\Item\ItemManagementInterface
     */
    private $itemManagement;
    /**
     * @var  Mirasvit\Rma\Api\Service\Rma\RmaManagement\SearchInterface
     */
    private $rmaSearchManagement;
    /**
     * @var \Drop\FatturazioneElettronica\Model\Utilities
     */
    private $fatturazioneElettronicaUtilities;

    /**
     * Pdf constructor.
     * @param Context $context
     * @param Renderer $addressRenderer
     * @param PaymentHelper $paymentHelper
     * @param InvoiceIdentity $identityContainer
     * @param Processor $templateFactory
     * @param Filesystem $filesystem
     * @param DirectoryList $directoryList
     * @param TemplatePaperForm $templatePaperForm
     * @param TemplatePaperOrientation $templatePaperOrientation
     * @param Data $helper
     * @param OrderFactory $orderFactory
     * @param \Magento\Sales\Model\Order\ItemRepository $orderItemRepository
     * @param \Mirasvit\Rma\Api\Repository\ReasonRepositoryInterface $reasonRepository
     * @param \Mirasvit\Rma\Api\Service\Rma\RmaManagementInterface $rmaManagement
     * @param \Mirasvit\Rma\Service\Rma\RmaOrder $rmaOrder
     * @param \Mirasvit\Rma\Api\Service\Item\ItemManagementInterface $itemManagement
     * @param \Mirasvit\Rma\Api\Service\Rma\RmaManagement\SearchInterface $rmaSearchManagement
     * @param \Drop\FatturazioneElettronica\Model\Utilities $fatturazioneElettronicaUtilities
     */
    public function __construct(
        Context $context,
        Renderer $addressRenderer,
        PaymentHelper $paymentHelper,
        InvoiceIdentity $identityContainer,
        Processor $templateFactory,
        Filesystem $filesystem,
        DirectoryList $directoryList,
        TemplatePaperForm $templatePaperForm,
        TemplatePaperOrientation $templatePaperOrientation,
        Data $helper,
        OrderFactory $orderFactory,
        ItemRepository $orderItemRepository,
        ReasonRepositoryInterface $reasonRepository,
        RmaManagement $rmaManagement,
        RmaOrder $rmaOrder,
        ItemManagementInterface $itemManagement,
        SearchInterface $rmaSearchManagement,
        FAEUtilities $fatturazioneElettronicaUtilities,
        MpdfFactory $mpdfFactory
    ) {
        $this->processor                = $templateFactory;
        $this->paymentHelper            = $paymentHelper;
        $this->identityContainer        = $identityContainer;
        $this->addressRenderer          = $addressRenderer;
        $this->filesystem               = $filesystem;
        $this->directoryList            = $directoryList;
        $this->templatePaperForm        = $templatePaperForm;
        $this->templatePaperOrientation = $templatePaperOrientation;
        $this->helper                   = $helper;
        $this->orderFactory             = $orderFactory;
        $this->orderItemRepository      = $orderItemRepository;
        $this->reasonRepository         = $reasonRepository;
        $this->rmaManagement            = $rmaManagement;
        $this->rmaOrder                 = $rmaOrder;
        $this->itemManagement          = $itemManagement;
        $this->rmaSearchManagement          = $rmaSearchManagement;
        $this->fatturazioneElettronicaUtilities          = $fatturazioneElettronicaUtilities;
        parent::__construct($context, $addressRenderer, $paymentHelper, $identityContainer, $templateFactory, $directoryList, $templatePaperForm, $templatePaperOrientation, $mpdfFactory);
    }

    /**
     * @param Rma $rma
     * @return $this
     */
    public function setRma(Rma $rma)
    {
        $this->rma = $rma;
        foreach($this->rmaManagement->getOrder($rma)->getInvoiceCollection() as $invoice) {
            $this->setInvoice($invoice);
            break;
        }
        return $this;
    }

    public function _transport()
    {
        $order = $this->order;

        $invoice = '';
        $invoice_comment = '';
        if($this->invoice instanceof Invoice) {
            $invoice = $this->invoice;
            $invoice_comment = $invoice->getCustomerNoteNotify() ? $invoice->getCustomerNote() : '';
        }

        $creditmemo = '';
        $creditmemo_comment = '';
        if($this->creditmemo instanceof Creditmemo) {
            $creditmemo = $this->creditmemo;
            $creditmemo_comment = $creditmemo->getCustomerNoteNotify() ? $creditmemo->getCustomerNote() : '';
        }

        $rma = '';
        $rmaItemHtml = '';
        $rmaTotal = 0;
        if($this->rma instanceof Rma) {
            $rma = $this->rma;
            $items = $this->rmaSearchManagement->getRequestedItems($rma);
            foreach ($items as $item) {
                $itemOrderId = $this->itemManagement->getOrderItem($item)->getOrderId();
                if ($itemOrderId == $order->getId()) {
                    $mageItem = $this->orderItemRepository->get($item->getOrderItemId());

                    $calculatedItemQty = $item->getQtyRequested();
                    $calculatedPrice = ($mageItem->getPrice() - (($mageItem->getDiscountAmount() * 100) / ($mageItem->getTaxPercent() + 100)) + $mageItem->getTaxAmount()) * $calculatedItemQty;

                    # fix for get price from bundle product
                    $productOptions = $mageItem->getProductOptions();
                    if(isset($productOptions['bundle_selection_attributes'])){
                        $bundleOptions = json_decode($productOptions['bundle_selection_attributes'], true);

                        $calculatedItemQty = $bundleOptions['qty'];
                        $calculatedPrice = ($bundleOptions['qty'] * $bundleOptions['price']);
                    }

                    $rmaItemHtml .= "
                        <tr>
                            <td>
                                <p class='product-name'>".$mageItem->getName()."</p>
                                <p class='sku'>SKU: ".$mageItem->getSku()."</p>
                            </td>
                            <td>" . $calculatedItemQty . "</td>
                            <td>" . $order->formatPrice($calculatedPrice) . "</td>
                            <td><span>" . __($this->reasonRepository->get($item->getReasonId())->getName()) ."</span></td>
                        </tr>";
                    $rmaTotal += $calculatedPrice;
                }
            }
        }

        $transport = [
            'menaged_drop_address' => "Managed by: " . $this->fatturazioneElettronicaUtilities->getManagedDropAddress($order),
            'rea_drop_info' => $this->fatturazioneElettronicaUtilities->getReaDropInfo($order),
            'order' => $order,
            'invoice' => $invoice,
            'creditmemo' => $creditmemo,
            'rma' => $rma,
            'rma_items' => $rmaItemHtml,
            'rma_total' => $order->formatPrice($rmaTotal),
            'invoice_comment' => $invoice_comment,
            'creditmemo_comment' => $creditmemo_comment,
            'billing' => $order->getBillingAddress(),
            'payment_html' => $this->getPaymentHtml($order),
            'paymentInfo' => $order->getPayment()->getMethodInstance()->getTitle(),
            'store' => $order->getStore(),
            'formattedShippingAddress' => $this->getFormattedShippingAddress($order),
            'formattedBillingAddress' => $this->getFormattedBillingAddress($order),
            'logo_path' => $this->filesystem->getDirectoryRead(DirectoryList::MEDIA)->getAbsolutePath() . 'email/logo/' . $this->helper->hasConfig('design/email/logo'),
            'return_address' => nl2br($this->helper->hasConfig('rma/general/return_address'))
        ];

        $processor = $this->processor;
        $processor->setVariables($transport);
        $processor->setTemplate($this->template);
        $parts = $processor->processTemplate();

        return $parts;
    }

}
