<?php
/**
 * Author: Simone Monterubbiano <s.monterubbiano@drop.it>
 * Date: 05/03/2019
 * File name: CreateRmaShipment.php
 * Project: drop/module-rma-mirasvit
 */
namespace Drop\RmaMirasvit\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Input\InputOption;

class CreateRmaShipment extends Command
{
    const RMAID = 'rmaid';
    /**
     * @var \Drop\RmaMirasvit\Model\Consumer\GspedFactory
     */
    private $gspedFactory;

    /**
     * CreateRmaShipment constructor.
     * @param \Drop\RmaMirasvit\Model\Consumer\GspedFactory $gspedFactory
     */
    public function __construct(
        \Drop\RmaMirasvit\Model\Consumer\GspedFactory $gspedFactory
    )
    {
        $this->gspedFactory = $gspedFactory;
        
        parent::__construct();
    }

    protected function configure()
    {
        // rmaId option
        $options = [
            new InputOption(
                self::RMAID,
                null,
                InputOption::VALUE_REQUIRED,
                'rmaid'
            )
        ];

        $this->setName('drop:rmamirasvit:creatermashipment')
            ->setDescription('Create RMA shipment with Gsped and add label to RMA (pass rma ID param. Es. --rmaid="19")')
            ->setDefinition($options);
        parent::configure();
    }

    public function execute( InputInterface $input, OutputInterface $output )
    {
        echo PHP_EOL;
        $rmaId = $input->getOption(self::RMAID);

        // Create Gsped shipment
        $this->gspedFactory->create()->process($rmaId);

        echo "Created shipment for RMA {$rmaId}".PHP_EOL;
    }
}
