<?php
/**
 * Author: Simone Monterubbiano <s.monterubbiano@drop.it>
 * Date: 04/03/2019
 * File name: RmaUpdated.php
 * Project: drop/module-rma-mirasvit
 */

namespace Drop\RmaMirasvit\Observer;

class RmaUpdated implements \Magento\Framework\Event\ObserverInterface
{
    const QUEUE_NAME = "create_gsped_rma_shipment";
    const STATUS_CLOSED = 5;

    /**
     * @var \Rcason\Mq\Api\PublisherInterface
     */
    private $publisher;
    /**
     * @var \Drop\RmaMirasvit\Helper\Data
     */
    private $helper;
    /**
     * @var \Drop\RmaMirasvit\Model\QueueFactory
     */
    private $queueFactory;
    /**
     * @var \Magento\Sales\Api\OrderRepositoryInterface
     */
    private $orderRepository;
    /**
     * @var \Mirasvit\Rma\Model\RmaFactory
     */
    private $rmaFactory;
        /**
     * @var \Mirasvit\Rma\Api\Service\Rma\RmaManagementInterface
     */
    private $rmaManagement;

    /**
     * RmaUpdated constructor.
     * @param \Rcason\Mq\Api\PublisherInterface $publisher
     * @param \Drop\RmaMirasvit\Helper\Data $helper
     * @param \Drop\RmaMirasvit\Model\QueueFactory $queueFactory
     * @param \Magento\Sales\Api\Data\OrderInterface $orderRepository
     * @param \Mirasvit\Rma\Model\RmaFactory $rmaFactory
     * @param \Mirasvit\Rma\Api\Service\Rma\RmaManagementInterface $rmaManagement
     */
    public function __construct(
        \Rcason\Mq\Api\PublisherInterface $publisher,
        \Drop\RmaMirasvit\Helper\Data $helper,
        \Drop\RmaMirasvit\Model\QueueFactory $queueFactory,
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        \Mirasvit\Rma\Model\RmaFactory $rmaFactory,
        \Mirasvit\Rma\Api\Service\Rma\RmaManagementInterface $rmaManagement
    )
    {
        $this->publisher = $publisher;
        $this->helper = $helper;
        $this->queueFactory = $queueFactory;
        $this->orderRepository = $orderRepository;
        $this->rmaFactory = $rmaFactory;
        $this->rmaManagement = $rmaManagement;
    }

    /**
     * If RMA status is closed delete pdf label from server
     * If job "create_gsped_rma_shipment" not exists create it
     * @param \Magento\Framework\Event\Observer $observer
     * @throws \Exception
     */
    public function execute( \Magento\Framework\Event\Observer $observer)
    {
        $rma = $observer->getEvent()->getRma();

        // If RMA status is closed delete labels from server
        if($rma["status_id"]==self::STATUS_CLOSED){
            $this->helper->deleteDocumentFiles($rma);
        }

        try{
            $order = $this->rmaManagement->getOrder($rma);
            $orderIncrementId = $order->getIncrementId();
        }catch (\Exception $e){
            throw new \Exception("Cannot load order from RMA - ".$e->getMessage());
        }

        try {
            // There is no way to check if it's a new RMA, so check if job with message rma_id exists
            $collection = $this->queueFactory->create()->getCollection();
            $collection->addFieldToFilter("queue_name", ["eq" => "create_gsped_rma_shipment"]);
            $collection->addFieldToFilter("message_content", ["like" => "%" . $rma["rma_id"] . "%"]);
            if ($collection->count()) {
                if(!is_null($order->getCustomerId())){
                    $rma->setCustomerId(
                        $order->getCustomerId()
                    );
                    $rma->save();
                }
                return $rma;
            }
        }catch (\Exception $e){
            throw new \Exception("Error during checking if job exists - ".$e->getMessage());
        }

        $this->publisher->publish(
            self::QUEUE_NAME,
            "Order #{$order->getIncrementId()} (RMA #{$rma->getIncrementId()}) - Create gsped shipment and save label to RMA",
            $rma["rma_id"]);
    }
}