##Modulo "drop/module-rma-mirasvit"

#### Required modules

- "mirasvit/module-rma"
- "eadesignro/module-pdfgenerator"
- "renatocason/magento2-module-mq-mysql"

#### Configurazione (!! LEGGERE E CONFIGURARE !!)
  1. Creare i seguenti custom field:

      - code: refund_info_payment_name
      - type: TEXT

      - code: refund_info_payment_surname
      - type: TEXT

      - code: refund_info_payment_iban
      - type: TEXT

      - code: drop_rma_timeline_change_status
      - type: MULTILINE-TEXT

  2. Aprire il pannello configurazione del modulo (Store > Configuration > Drop Rma Mirasvit) quindi scegliere la configurazione desiderata.
  3. Aggiungere il template per i campi per informazioni rimborso (vedi sotto)

#### Flusso

1. L'utente o l'admin crea una nuova richiesta di reso
1. Il modulo cattura l'evento "rma_add_message_after" e verifica che sia un nuovo reso (verica se il job esiste)
2. Viene generato il documento di reso attravero "eadesignro/module-pdfgenerator"
3. Viene inviata la email con le istruzioni di reso ed i link all'etichetta di spedizione e al documento di reso
4. Nel momento della nota di credito, il customercare imposta lo stato a "Closed" e i documenti di reso vengono cancellati dal server

#### Status resi

1. Reso creato: Pending Approval (automatico)
2. Spedizione creata e documenti inviati: Approved (automatico)
3. Reso non accettato: Rejected (manuale)
3. Nota di credito creata: Closed (manuale)

#### Body email italiano

Copiare e incollare sul backoffice su Statuses / Approved

```
Gentile cliente,<br/>
ti comunichiamo che la tua richiesta di reso è stata accettata.
<br><br>
<strong>Richiesta reso:</strong> #{{var rma.increment_id}}
<br><br>
Ecco alcune informazioni importanti per preparare il tuo reso:

<ul>
{{depend rma.guest_print_label_url}}
<li><strong>etichetta di spedizione:</strong> stampa l'etichetta di spedizione che puoi scaricare a questo <a href="{{var rma.guest_print_label_url}}">link</a> ed incollala sul pacco</li>
{{/depend}}
<li><strong>stato del pacco e del prodotto:</strong> gli articoli devono essere integri, non utilizzati e con tutte le etichette e i cartellini originali apposti. I prodotti devono essere riposti all'interno del pacco originale, sigillato in modo sicuro.</li>
<li><strong>documento di reso:</strong> stampa il <a href='{{var rma.guest_print_url}}'>documento di reso</a> scaricabile a questo link ed inseriscilo nel pacco.</li>
<li><strong>indirizzo per il reso:</strong><br/>{{var rma.return_address_html | raw}}</li>
<li><strong>costo delle spese di spedizione:</strong> le spese di spedizione per il reso sono gratuite.</li>
<li><strong>tempi e modalità di rimborso:</strong> ll rimborso sarà effettuato non appena il reso arriverà presso i magazzini e i capi saranno verificati. Dopo l'accettazione effettueremo immediatamente il rimborso e invieremo un'e-mail di conferma. I tempi di rimborso variano in base al metodo di pagamento utilizzato per effettuare l'ordine:
<ul>
<li><strong>carta di credito/debito:</strong>la nostra banca effettuerà il rimborso entro 7 giorni lavorativi dall'e-mail Conferma Accettazione Reso. Il tempo necessario per visualizzare il rimborso sul proprio conto dipende dall'Istituto di emissione della carta, ma normalmente avviene entro 30 giorni.</li>
<li><strong>PayPal:</strong> il rimborso sarà visibile sul conto PayPal entro 24 ore dall'e-mail Conferma Accettazione Reso. Il rimborso effettivo sull'eventuale carta di credito collegata al tuo conto PayPal dipende dall'istituto che ha emesso la carta.</li>
<li><strong>bonifico bancario:</strong> il rimborso sarà effettuato tramite bonifico su un conto corrente bancario da indicare nel Modulo di reso. La somma rimborsata sarà visibile sull'estratto conto entro 10 giorni lavorativi dall'e-mail Conferma Accettazione.</li>
<li><strong>contanti alla consegna:</strong> il rimborso avviene sul conto corrente da indicare nel Modulo di reso. La somma rimborsata sarà visibile sull'estratto conto entro 10 giorni lavorativi dall'e-mail Conferma Accettazione.</li>
</ul>
</li>
<li>Puoi controllare lo stato del tuo reso o rispondere a questo messaggio online al seguente <a href="{{var rma.url }}">link</a></li>
</ul>
<br/><br/>
<strong>Attenzione: non incollando l'etichetta di spedizione sul pacco, la spedizione non potrà essere tracciata.</strong>
```

#### Body email inglese

Copiare e incollare sul backoffice su Statuses / Approved

```
Dear customer,<br/>
we inform you that your return request was accepted.
<br><br>
<strong>Return request:</strong> #{{var rma.increment_id}}
<br><br>
To return your item(s), please follow these instructions:

<ul>
<li>the items must be returned clean, unworn and have all of their tags and original packaging.</li>
<li><strong>delivery note:</strong> print the <a href='{{var rma.guest_print_url}}'>delivery note</a> downloadable at this link and prepare your parcel enclosing it.</li>
<li><strong>the return address is:</strong><br/>{{var rma.return_address_html | raw}}</li>
<li><strong>shipping cost:</strong> the shipping costs for the return are at your charge. If you are returning products from a country outside the CE area possible Custom Duties and local taxes will also be at your charge.</li>
<li><strong>refund procedures:</strong> only after we have received the returned products and checked that the products meet all requirements, you will receive an e-mail that the returned products have been accepted and we will reimburse the amount owed you. The time period for refunding the amount you paid for purchasing the returned products depends on the payment method used:
<ul>
<li><strong>Credit/Debit Card:</strong> the refunded amount will be available to Clients in roughly 10 days and within their next billing statement. Processing time may vary depending on the Credit Card Company.</li>
<li><strong>PayPal:</strong> refunds will be credited to your PayPal. The actual reimbursement to the credit card associated with your PayPal account depends on the company that issued the card.</li>
</ul>
</li>
<li>You can check the status or reply to this message online at this <a href="{{var rma.url }}">link</a></li>
</ul>
```

### Template campi per informazioni rimborso da aggiungere dentro templates/rma/new/step2.phtml
```
<?php $isOfflinePayment = (\Magento\Framework\App\ObjectManager::getInstance()->get(\Drop\RmaMirasvit\Helper\Data::class))->getIsNeedAddCustomFieldForRefundInfo() && in_array($order->getPayment()->getMethod(), [
  \Magento\OfflinePayments\Model\Banktransfer::PAYMENT_METHOD_BANKTRANSFER_CODE ?? "",
  \Magento\OfflinePayments\Model\Cashondelivery::PAYMENT_METHOD_CASHONDELIVERY_CODE ?? "",
  \MSP\CashOnDelivery\Model\Payment::CODE ?? "",
]); ?>
<?php if($isOfflinePayment): ?>
<div class="card">
	<div class="card-header">
		<strong>Informazioni per il rimborso</strong>
    <p style="margin-top: 15px;">
          Inserisci i dati del tuo conto corrente per ricevere il rimborso.
    </p>
	</div>
	<div class="card-body">
		<fieldset class="fieldset">
			<div class="field form-group">
				<label class="label">
					<span>Nome dell'intestatario</span>
				</label>
				<div class="control">
					<input data-validate="{'required-entry':'true'}" class="input-text form-control required-entry" type="text" name="refund_info_payment_name" value="" placeholder="Nome dell'intestatario" />
				</div>
			</div>

			<div class="field form-group">
				<label class="label">
					<span>Cognome dell'intestatario</span>
				</label>
				<div class="control">
					<input data-validate="{'required-entry':'true'}" class="input-text form-control required-entry" type="text" name="refund_info_payment_surname" value="" placeholder="Cognome dell'intestatario" />
				</div>
			</div>

			<div class="field form-group">
				<label class="label">
					<span>IBAN</span>
				</label>
				<div class="control">
					<input data-validate="{'required-entry':'true'}" class="input-text form-control required-entry" type="text" name="refund_info_payment_iban" value="" placeholder="IBAN" />
				</div>
			</div>

		</fieldset>
	</div>
</div>
<?php endif; ?>
```

#### Varie configurazione di Mirasvit necessarie (TODO: configurare in automatico)

1. Creare utente per mazzino. Verrà mostrato tra gli owner e tutte le email gli verranno inviate
2. Send blind carbon copy (BCC) of all emails to "customercare@drop.it"
3. Creare custom field "tracking_link" di tipo text da backoffice
