<?php
/**
 * Author: Simone Monterubbiano <s.monterubbiano@drop.it>
 * Date: 04/03/2019
 * File name: RmaUpdated.php
 * Project: drop/module-rma-mirasvit
 */

namespace Drop\RmaMirasvit\Observer;

class RmaUpdated implements \Magento\Framework\Event\ObserverInterface
{

    /**
     * @var int
     */
    const STATUS_CLOSED = 5;

    /**
     * @var int
     */
    const STATUS_APPROVED = 2;

    /**
     * @var int
     */
    const STATUS_PENDING = 1;

    /**
     * @var \Rcason\Mq\Api\PublisherInterface
     */
    private $publisher;

    /**
     * @var \Drop\RmaMirasvit\Helper\Data
     */
    private $helper;

    /**
     * @var \Drop\RmaMirasvit\Model\QueueFactory
     */
    private $queueFactory;

    /**
     * @var \Magento\Sales\Api\OrderRepositoryInterface
     */
    private $orderRepository;

    /**
     * @var \Mirasvit\Rma\Model\RmaFactory
     */
    private $rmaFactory;

    /**
     * @var \Mirasvit\Rma\Api\Service\Rma\RmaManagementInterface
     */
    private $rmaManagement;

    /**
     * @var \Mirasvit\Rma\Helper\Mail
     */
    private $rmaMail;

    /**
     * @var \Mirasvit\Rma\Api\Repository\StatusRepositoryInterface
     */
    private $statusRepository;

    /**
     * @var \Magento\Framework\Stdlib\DateTime\TimezoneInterface
     */
    private $timezone;

    /**
     * RmaUpdated constructor.
     * @param \Rcason\Mq\Api\PublisherInterface $publisher
     * @param \Drop\RmaMirasvit\Helper\Data $helper
     * @param \Drop\RmaMirasvit\Model\QueueFactory $queueFactory
     * @param \Magento\Sales\Api\Data\OrderInterface $orderRepository
     * @param \Mirasvit\Rma\Model\RmaFactory $rmaFactory
     * @param \Mirasvit\Rma\Api\Service\Rma\RmaManagementInterface $rmaManagement
     */
    public function __construct(
        \Rcason\Mq\Api\PublisherInterface $publisher,
        \Drop\RmaMirasvit\Helper\Data $helper,
        \Drop\RmaMirasvit\Model\QueueFactory $queueFactory,
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        \Mirasvit\Rma\Model\RmaFactory $rmaFactory,
        \Mirasvit\Rma\Api\Service\Rma\RmaManagementInterface $rmaManagement,
        \Mirasvit\Rma\Helper\Mail $rmaMail,
        \Mirasvit\Rma\Api\Repository\StatusRepositoryInterface $statusRepository,
        \Magento\Framework\Stdlib\DateTime\TimezoneInterface $timezone
    ) {
        $this->publisher = $publisher;
        $this->helper = $helper;
        $this->queueFactory = $queueFactory;
        $this->orderRepository = $orderRepository;
        $this->rmaFactory = $rmaFactory;
        $this->rmaManagement = $rmaManagement;
        $this->rmaMail = $rmaMail;
        $this->statusRepository = $statusRepository;
        $this->timezone = $timezone;
    }

    /**
     * If RMA status is closed delete pdf label from server
     * @param \Magento\Framework\Event\Observer $observer
     * @throws \Exception
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $rma = $observer->getEvent()->getRma();

        $this->updateTimelineStatus(
            $rma
        );

        try {
            $order = $this->rmaManagement->getOrder($rma);
            $orderIncrementId = $order->getIncrementId();
        } catch (\Exception $e) {
            throw new \Exception("Cannot load order from RMA - ".$e->getMessage());
        }

        //set orderId if not set
        try {
            if ($rma->getOrderId() == 0 || is_null($rma->getOrderId())) {
                $rma->setOrderId($order->getId())->save();
            }
        } catch (\Exception $e) {
            throw new \Exception("Cannot set orderId for RMA - ".$e->getMessage());
        }
    }

    private function updateTimelineStatus($rma)
    {
        try {
            $_na = $this->statusRepository->get($rma['status_id'])->getName() ?? null;

            if (empty($_na)) {
                return null;
            }

            $_ti = $this->timezone->date()->format('d/m/Y H:i:s');
            $_s = $rma->getDropRmaTimelineChangeStatus() . $_na . " > " . $_ti . PHP_EOL;
            $rma->setDropRmaTimelineChangeStatus($_s);
        } catch (\Exception $e) {
            return null;
        }
    }
}
