<?php

namespace Drop\RmaMirasvit\Helper;

use Mirasvit\Rma\Model\Rma;
use Eadesigndev\Pdfgenerator\Model\ResourceModel\Pdfgenerator\CollectionFactory as templateCollectionFactory;
use Eadesigndev\Pdfgenerator\Model\Source\TemplateActive;
use Eadesigndev\Pdfgenerator\Model\Source\AbstractSource;
use \Magento\Framework\App\Filesystem\DirectoryList;

/**
 * Data
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

class Data
{
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var \Mirasvit\Rma\Repository\RmaRepository
     */
    private $rmaRepository;
    /**
     * @var \Mirasvit\Rma\Repository\AttachmentRepository
     */
    private $attachmentRepository;
    /**
     * @var \Mirasvit\Rma\Service\Attachment\AttachmentManagement
     */
    private $attachmentManagement;
    /**
     * @var \Magento\Framework\Filesystem
     */
    private $filesystem;
    /**
     * @var \Magento\Framework\Stdlib\DateTime\DateTime
     */
    private $date;

    /**
     * Data constructor.
     * @param templateCollectionFactory $_templateCollection
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Mirasvit\Rma\Service\Attachment\AttachmentManagement $attachmentManagement
     * @param \Magento\Framework\Filesystem $filesystem
     * @param \Magento\Framework\Stdlib\DateTime\DateTime $date
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Mirasvit\Rma\Service\Attachment\AttachmentManagement $attachmentManagement,
        \Magento\Framework\Filesystem $filesystem,
        \Magento\Framework\Stdlib\DateTime\DateTime $date
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->attachmentManagement = $attachmentManagement;
        $this->filesystem = $filesystem;
        $this->date = $date;
    }

    public function getConfig($config_path)
    {
        return $this->scopeConfig->getValue(
            $config_path,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return bool
     */
    public function getIsNeedAddCustomFieldForRefundInfo()
    {
        return (bool) $this->getConfig('drop_rma_mirasvit_configuration/configuration/is_need_add_custom_field_for_refund_info');
    }
}
