<?php
/**
 * Author: Simone Monterubbiano <s.monterubbiano@drop.it>
 * Date: 11/03/2019
 * File name: Queue.php
 * Project: drop/module-rma-mirasvit
 */

namespace Drop\RmaMirasvit\Model;

class Queue extends \Magento\Framework\Model\AbstractModel implements \Magento\Framework\DataObject\IdentityInterface
{
    const CACHE_TAG = 'drop_rmamirasvit_queue';

    protected $_cacheTag = 'drop_rmamirasvit_queue';
    protected $_eventPrefix = 'drop_rmamirasvit_queue';

    protected function _construct()
    {
        $this->_init('Drop\RmaMirasvit\Model\ResourceModel\Queue');
    }

    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    public function getDefaultValues()
    {
        $values = [];

        return $values;
    }
}