<?php

namespace Drop\RmaMirasvit\Helper;

use Mirasvit\Rma\Model\Rma;
use Eadesigndev\Pdfgenerator\Model\ResourceModel\Pdfgenerator\CollectionFactory as templateCollectionFactory;
use Eadesigndev\Pdfgenerator\Model\Source\TemplateActive;
use Eadesigndev\Pdfgenerator\Model\Source\AbstractSource;
use \Magento\Framework\App\Filesystem\DirectoryList;

/**
 * Data
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

class Data
{
    const GSPED_DIR = "gsped";

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var \Mirasvit\Rma\Repository\RmaRepository
     */
    private $rmaRepository;
    /**
     * @var \Mirasvit\Rma\Repository\AttachmentRepository
     */
    private $attachmentRepository;
    /**
     * @var \Mirasvit\Rma\Service\Attachment\AttachmentManagement
     */
    private $attachmentManagement;
    /**
     * @var \Magento\Framework\Filesystem
     */
    private $filesystem;
    /**
     * @var \Magento\Framework\Stdlib\DateTime\DateTime
     */
    private $date;

    /**
     * Data constructor.
     * @param templateCollectionFactory $_templateCollection
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Mirasvit\Rma\Service\Attachment\AttachmentManagement $attachmentManagement
     * @param \Magento\Framework\Filesystem $filesystem
     * @param \Magento\Framework\Stdlib\DateTime\DateTime $date
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Mirasvit\Rma\Service\Attachment\AttachmentManagement $attachmentManagement,
        \Magento\Framework\Filesystem $filesystem,
        \Magento\Framework\Stdlib\DateTime\DateTime $date
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->attachmentManagement = $attachmentManagement;
        $this->filesystem = $filesystem;
        $this->date = $date;
    }

    public function getConfig($config_path)
    {
        return $this->scopeConfig->getValue(
            $config_path,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return bool
     */
    public function getIsNeedGenerateJobGspedShipment()
    {
        return (bool) $this->getConfig('drop_rma_mirasvit_configuration/configuration/is_need_generate_job_gsped_shipment');
    }

    /**
     * @return bool
     */
    public function getIsNeedGenerateJobGspedOnlyIt()
    {
        return (bool) $this->getConfig('drop_rma_mirasvit_configuration/configuration/is_need_generate_job_gsped_only_it');
    }

    /**
     * Return receipt address for RMA from Gsped configuration
     * @return array
     */
    public function getGspedRcpt()
    {
        $today = $today =$this->date->gmtDate("Y-m-d");
        $date_req_ritiro = date('Y-m-d', strtotime($today . ' +1 Weekday'));

        return [
            "rcpt_addr" => $this->getConfig("rma/gsped/rcpt_addr"),
            "rcpt_cap" => $this->getConfig("rma/gsped/rcpt_cap"),
            "rcpt_city" => $this->getConfig("rma/gsped/rcpt_city"),
            "rcpt_prov" => $this->getConfig("rma/gsped/rcpt_prov"),
            "rcpt_contact" => $this->getConfig("rma/gsped/rcpt_contact"),
            "rcpt_country_code" => $this->getConfig("rma/gsped/rcpt_country_code"),
            "rcpt_email" => $this->getConfig("rma/gsped/rcpt_email"),
            "rcpt_name" => $this->getConfig("rma/gsped/rcpt_name"),
            "rcpt_phone" => $this->getConfig("rma/gsped/rcpt_phone"),
            "date_req_ritiro" => $date_req_ritiro,// yyyy-mm-dd hh:mm:ss
            "opening_time" => $this->getConfig("rma/gsped/opening_time"), // hh:mm,
            "closing_time" => $this->getConfig("rma/gsped/closing_time"), // hh:mm,
        ];
    }

    /**
     * @param $rma
     * @throws \Exception
     */
    public function deleteDocumentFiles($rma)
    {
        try {
            $attachments = $this->attachmentManagement->getAttachments("return_label", $rma["rma_id"]);
            foreach ($attachments as $attach):
                $name = $attach["name"];
            unlink($this->filesystem->getDirectoryRead(DirectoryList::PUB)->getAbsolutePath() . self::GSPED_DIR . DIRECTORY_SEPARATOR . $name);
            endforeach;
        } catch (\Exception $e) {
            throw new \Exception("Cannot delete label from server - ".$e->getMessage());
        }
    }
}
